/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.argumentMatching;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.argumentMatching.ArgumentMatcher;
import mockit.internal.expectations.argumentMatching.ArgumentMismatch;

public final class ClassMatcher
implements ArgumentMatcher<ClassMatcher> {
    private static final Map<Class<?>, ClassMatcher> PRIMITIVE_MATCHERS = new IdentityHashMap(16);
    @Nonnull
    private final String nameOfExpectedClass;
    @Nonnull
    private final Class<?> matchableClass;

    @Nonnull
    public static ClassMatcher create(@Nonnull Class<?> expectedClass) {
        ClassMatcher matcher = PRIMITIVE_MATCHERS.get(expectedClass);
        if (matcher == null) {
            matcher = new ClassMatcher(expectedClass);
        }
        return matcher;
    }

    private ClassMatcher(@Nonnull Class<?> expectedClass) {
        this.nameOfExpectedClass = expectedClass.getName();
        this.matchableClass = expectedClass;
    }

    private ClassMatcher(@Nonnull Class<?> primitiveClass, @Nonnull Class<?> primitiveWrapperClass) {
        this.nameOfExpectedClass = primitiveClass.getName();
        this.matchableClass = primitiveWrapperClass;
    }

    @Override
    public boolean same(@Nonnull ClassMatcher other) {
        return this.matchableClass == other.matchableClass;
    }

    @Override
    public boolean matches(@Nullable Object argValue) {
        return this.matchableClass.isInstance(argValue);
    }

    @Override
    public void writeMismatchPhrase(@Nonnull ArgumentMismatch argumentMismatch) {
        argumentMismatch.append("an instance of ").append(this.nameOfExpectedClass);
    }

    static {
        PRIMITIVE_MATCHERS.put(Boolean.class, new ClassMatcher(Boolean.class));
        PRIMITIVE_MATCHERS.put(Character.class, new ClassMatcher(Character.class));
        PRIMITIVE_MATCHERS.put(Byte.class, new ClassMatcher(Byte.class));
        PRIMITIVE_MATCHERS.put(Short.class, new ClassMatcher(Short.class));
        PRIMITIVE_MATCHERS.put(Integer.class, new ClassMatcher(Integer.class));
        PRIMITIVE_MATCHERS.put(Float.class, new ClassMatcher(Float.class));
        PRIMITIVE_MATCHERS.put(Long.class, new ClassMatcher(Long.class));
        PRIMITIVE_MATCHERS.put(Double.class, new ClassMatcher(Double.class));
        PRIMITIVE_MATCHERS.put(Boolean.TYPE, new ClassMatcher(Boolean.TYPE, Boolean.class));
        PRIMITIVE_MATCHERS.put(Character.TYPE, new ClassMatcher(Character.TYPE, Character.class));
        PRIMITIVE_MATCHERS.put(Byte.TYPE, new ClassMatcher(Byte.TYPE, Byte.class));
        PRIMITIVE_MATCHERS.put(Short.TYPE, new ClassMatcher(Short.TYPE, Short.class));
        PRIMITIVE_MATCHERS.put(Integer.TYPE, new ClassMatcher(Integer.TYPE, Integer.class));
        PRIMITIVE_MATCHERS.put(Float.TYPE, new ClassMatcher(Float.TYPE, Float.class));
        PRIMITIVE_MATCHERS.put(Long.TYPE, new ClassMatcher(Long.TYPE, Long.class));
        PRIMITIVE_MATCHERS.put(Double.TYPE, new ClassMatcher(Double.TYPE, Double.class));
    }
}

