/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;

final class UnorderedVerificationPhase
extends BaseVerificationPhase {
    @Nonnull
    final List<VerifiedExpectation> verifiedExpectations = new ArrayList<VerifiedExpectation>();

    UnorderedVerificationPhase(@Nonnull RecordAndReplayExecution recordAndReplay, @Nonnull List<Expectation> expectationsInReplayOrder, @Nonnull List<Object> invocationInstancesInReplayOrder, @Nonnull List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay, expectationsInReplayOrder, invocationInstancesInReplayOrder, invocationArgumentsInReplayOrder);
    }

    @Override
    @Nonnull
    protected List<ExpectedInvocation> findNonStrictExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        if (!this.matchInstance && this.recordAndReplay.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
            this.matchInstance = true;
        }
        this.replayIndex = -1;
        ArrayList<ExpectedInvocation> matchingInvocationsWithDifferentArgs = new ArrayList<ExpectedInvocation>();
        int n = this.expectationsInReplayOrder.size();
        for (int i = 0; i < n; ++i) {
            Object[] replayArgs;
            Object replayInstance;
            Expectation replayExpectation = (Expectation)this.expectationsInReplayOrder.get(i);
            if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance = this.invocationInstancesInReplayOrder.get(i), replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(i))) {
                Expectation verification = this.expectationBeingVerified();
                this.replayIndex = i;
                ++verification.constraints.invocationCount;
                this.currentExpectation = replayExpectation;
                this.mapNewInstanceToReplacementIfApplicable(mock);
                continue;
            }
            if (this.matchingInvocationWithDifferentArgs == null) continue;
            matchingInvocationsWithDifferentArgs.add(this.matchingInvocationWithDifferentArgs);
        }
        if (this.replayIndex >= 0) {
            this.pendingError = this.verifyConstraints();
        }
        return matchingInvocationsWithDifferentArgs;
    }

    @Nullable
    private Error verifyConstraints() {
        ExpectedInvocation lastInvocation = ((Expectation)this.expectationsInReplayOrder.get((int)this.replayIndex)).invocation;
        Object[] lastArgs = (Object[])this.invocationArgumentsInReplayOrder.get(this.replayIndex);
        Expectation expectation = this.expectationBeingVerified();
        return expectation.verifyConstraints(lastInvocation, lastArgs, 1, -1);
    }

    @Override
    void addVerifiedExpectation(@Nonnull VerifiedExpectation verifiedExpectation) {
        super.addVerifiedExpectation(verifiedExpectation);
        this.verifiedExpectations.add(verifiedExpectation);
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Error errorThrown;
        this.pendingError = null;
        Expectation verifying = this.expectationBeingVerified();
        if (this.replayIndex >= 0) {
            ExpectedInvocation replayInvocation = ((Expectation)this.expectationsInReplayOrder.get((int)this.replayIndex)).invocation;
            Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(this.replayIndex);
            errorThrown = verifying.verifyConstraints(replayInvocation, replayArgs, minInvocations, maxInvocations);
        } else {
            errorThrown = verifying.verifyConstraints(minInvocations);
        }
        if (errorThrown != null) {
            throw errorThrown;
        }
    }

    @Nullable
    VerifiedExpectation firstExpectationVerified() {
        VerifiedExpectation first = null;
        for (VerifiedExpectation expectation : this.verifiedExpectations) {
            if (first != null && expectation.replayIndex >= first.replayIndex) continue;
            first = expectation;
        }
        return first;
    }
}

