/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationResults;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.util.AutoBoxing;
import mockit.internal.util.MethodFormatter;

final class ReturnTypeConversion {
    private static final Class<?>[] STRING = new Class[]{String.class};
    @Nonnull
    private final Expectation expectation;
    @Nonnull
    private final Class<?> returnType;
    @Nonnull
    private final Object valueToReturn;

    ReturnTypeConversion(@Nonnull Expectation expectation, @Nonnull Class<?> returnType, @Nonnull Object value) {
        this.expectation = expectation;
        this.returnType = returnType;
        this.valueToReturn = value;
    }

    private boolean hasReturnOfDifferentType() {
        return !this.returnType.isArray() && !Iterable.class.isAssignableFrom(this.returnType) && !Iterator.class.isAssignableFrom(this.returnType) && !this.returnType.isAssignableFrom(this.valueToReturn.getClass());
    }

    void addConvertedValue() {
        Class<?> wrapperType = AutoBoxing.isWrapperOfPrimitiveType(this.returnType) ? this.returnType : AutoBoxing.getWrapperType(this.returnType);
        Class<?> valueType = this.valueToReturn.getClass();
        if (valueType == wrapperType) {
            this.addReturnValue(this.valueToReturn);
        } else if (wrapperType != null && AutoBoxing.isWrapperOfPrimitiveType(valueType)) {
            this.addPrimitiveValueConvertingAsNeeded(wrapperType);
        } else {
            boolean valueIsArray = valueType.isArray();
            if (valueIsArray || this.valueToReturn instanceof Iterable || this.valueToReturn instanceof Iterator) {
                this.addMultiValuedResultBasedOnTheReturnType(valueIsArray);
            } else {
                if (wrapperType != null) {
                    throw this.newIncompatibleTypesException();
                }
                this.addResultFromSingleValue();
            }
        }
    }

    private void addReturnValue(@Nonnull Object returnValue) {
        this.expectation.getResults().addReturnValueResult(returnValue);
    }

    private void addMultiValuedResultBasedOnTheReturnType(boolean valueIsArray) {
        if (this.returnType == Void.TYPE) {
            this.addMultiValuedResult(valueIsArray);
        } else if (this.returnType == Object.class) {
            this.addReturnValue(this.valueToReturn);
        } else {
            if (valueIsArray && this.addCollectionOrMapWithElementsFromArray()) {
                return;
            }
            if (this.hasReturnOfDifferentType()) {
                this.addMultiValuedResult(valueIsArray);
            } else {
                this.addReturnValue(this.valueToReturn);
            }
        }
    }

    private void addMultiValuedResult(boolean valueIsArray) {
        InvocationResults results = this.expectation.getResults();
        if (valueIsArray) {
            results.addResults(this.valueToReturn);
        } else if (this.valueToReturn instanceof Iterable) {
            results.addResults((Iterable)this.valueToReturn);
        } else {
            results.addDeferredResults((Iterator)this.valueToReturn);
        }
    }

    private boolean addCollectionOrMapWithElementsFromArray() {
        int n = Array.getLength(this.valueToReturn);
        Object values = null;
        if (this.returnType.isAssignableFrom(ListIterator.class)) {
            ArrayList<Object> list = new ArrayList<Object>(n);
            this.addArrayElements(list, n);
            values = list.listIterator();
        } else if (this.returnType.isAssignableFrom(List.class)) {
            values = this.addArrayElements(new ArrayList<Object>(n), n);
        } else if (this.returnType.isAssignableFrom(Set.class)) {
            values = this.addArrayElements(new LinkedHashSet<Object>(n), n);
        } else if (this.returnType.isAssignableFrom(SortedSet.class)) {
            values = this.addArrayElements(new TreeSet<Object>(), n);
        } else if (this.returnType.isAssignableFrom(Map.class)) {
            values = this.addArrayElements(new LinkedHashMap<Object, Object>(n), n);
        } else if (this.returnType.isAssignableFrom(SortedMap.class)) {
            values = this.addArrayElements(new TreeMap<Object, Object>(), n);
        }
        if (values != null) {
            this.expectation.getResults().addReturnValue(values);
            return true;
        }
        return false;
    }

    @Nonnull
    private Object addArrayElements(@Nonnull Collection<Object> values, int elementCount) {
        for (int i = 0; i < elementCount; ++i) {
            Object element = Array.get(this.valueToReturn, i);
            values.add(element);
        }
        return values;
    }

    @Nullable
    private Object addArrayElements(@Nonnull Map<Object, Object> values, int elementPairCount) {
        for (int i = 0; i < elementPairCount; ++i) {
            Object keyAndValue = Array.get(this.valueToReturn, i);
            if (keyAndValue == null || !keyAndValue.getClass().isArray()) {
                return null;
            }
            Object key = Array.get(keyAndValue, 0);
            Object element = Array.getLength(keyAndValue) > 1 ? Array.get(keyAndValue, 1) : null;
            values.put(key, element);
        }
        return values;
    }

    private void addResultFromSingleValue() {
        if (this.returnType == Object.class) {
            this.addReturnValue(this.valueToReturn);
        } else {
            if (this.returnType == Void.TYPE) {
                throw this.newIncompatibleTypesException();
            }
            if (this.returnType.isArray()) {
                this.addArray();
            } else if (this.returnType.isAssignableFrom(ArrayList.class)) {
                this.addCollectionWithSingleElement(new ArrayList<Object>(1));
            } else if (this.returnType.isAssignableFrom(LinkedList.class)) {
                this.addCollectionWithSingleElement(new LinkedList<Object>());
            } else if (this.returnType.isAssignableFrom(HashSet.class)) {
                this.addCollectionWithSingleElement(new HashSet<Object>(1));
            } else if (this.returnType.isAssignableFrom(TreeSet.class)) {
                this.addCollectionWithSingleElement(new TreeSet<Object>());
            } else if (this.returnType.isAssignableFrom(ListIterator.class)) {
                this.addListIterator();
            } else if (this.valueToReturn instanceof CharSequence) {
                this.addCharSequence((CharSequence)this.valueToReturn);
            } else {
                this.addPrimitiveValue();
            }
        }
    }

    @Nonnull
    private IllegalArgumentException newIncompatibleTypesException() {
        ExpectedInvocation invocation = this.expectation.invocation;
        String valueTypeName = this.valueToReturn.getClass().getName().replace("java.lang.", "");
        String returnTypeName = this.returnType.getName().replace("java.lang.", "");
        MethodFormatter methodDesc = new MethodFormatter(invocation.getClassDesc(), invocation.getMethodNameAndDescription());
        String msg = "Value of type " + valueTypeName + " incompatible with return type " + returnTypeName + " of " + methodDesc;
        return new IllegalArgumentException(msg);
    }

    private void addArray() {
        Object array = Array.newInstance(this.returnType.getComponentType(), 1);
        Array.set(array, 0, this.valueToReturn);
        this.addReturnValue(array);
    }

    private void addCollectionWithSingleElement(@Nonnull Collection<Object> container) {
        container.add(this.valueToReturn);
        this.addReturnValue(container);
    }

    private void addListIterator() {
        ArrayList<Object> l = new ArrayList<Object>(1);
        l.add(this.valueToReturn);
        ListIterator iterator = l.listIterator();
        this.addReturnValue(iterator);
    }

    private void addCharSequence(@Nonnull CharSequence textualValue) {
        Object convertedValue = textualValue;
        if (this.returnType.isAssignableFrom(ByteArrayInputStream.class)) {
            convertedValue = new ByteArrayInputStream(textualValue.toString().getBytes());
        } else if (this.returnType.isAssignableFrom(StringReader.class)) {
            convertedValue = new StringReader(textualValue.toString());
        } else if (!(textualValue instanceof StringBuilder) && this.returnType.isAssignableFrom(StringBuilder.class)) {
            convertedValue = new StringBuilder(textualValue);
        } else if (!(textualValue instanceof CharBuffer) && this.returnType.isAssignableFrom(CharBuffer.class)) {
            convertedValue = CharBuffer.wrap(textualValue);
        } else {
            Object valueFromText = ConstructorReflection.newInstanceUsingPublicConstructorIfAvailable(this.returnType, STRING, textualValue);
            if (valueFromText != null) {
                convertedValue = valueFromText;
            }
        }
        this.addReturnValue(convertedValue);
    }

    private void addPrimitiveValue() {
        Class<?> primitiveType = AutoBoxing.getPrimitiveType(this.valueToReturn.getClass());
        if (primitiveType != null) {
            Class[] parameterType = new Class[]{primitiveType};
            Object convertedValue = ConstructorReflection.newInstanceUsingPublicConstructorIfAvailable(this.returnType, parameterType, this.valueToReturn);
            if (convertedValue == null) {
                convertedValue = MethodReflection.invokePublicIfAvailable(this.returnType, null, "valueOf", parameterType, this.valueToReturn);
            }
            if (convertedValue != null) {
                this.addReturnValue(convertedValue);
                return;
            }
        }
        throw this.newIncompatibleTypesException();
    }

    private void addPrimitiveValueConvertingAsNeeded(@Nonnull Class<?> targetType) {
        Object convertedValue = null;
        if (this.valueToReturn instanceof Number) {
            convertedValue = ReturnTypeConversion.convertFromNumber(targetType, (Number)this.valueToReturn);
        } else if (this.valueToReturn instanceof Character) {
            convertedValue = ReturnTypeConversion.convertFromChar(targetType, ((Character)this.valueToReturn).charValue());
        }
        if (convertedValue == null) {
            throw this.newIncompatibleTypesException();
        }
        this.addReturnValue(convertedValue);
    }

    @Nullable
    private static Object convertFromNumber(@Nonnull Class<?> targetType, @Nonnull Number number) {
        if (targetType == Integer.class) {
            return number.intValue();
        }
        if (targetType == Short.class) {
            return number.shortValue();
        }
        if (targetType == Long.class) {
            return number.longValue();
        }
        if (targetType == Byte.class) {
            return number.byteValue();
        }
        if (targetType == Double.class) {
            return number.doubleValue();
        }
        if (targetType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (targetType == Character.class) {
            return Character.valueOf((char)number.intValue());
        }
        return null;
    }

    @Nullable
    private static Object convertFromChar(@Nonnull Class<?> targetType, char c) {
        if (targetType == Integer.class) {
            return (int)c;
        }
        if (targetType == Short.class) {
            return (short)c;
        }
        if (targetType == Long.class) {
            return (long)c;
        }
        if (targetType == Byte.class) {
            return (byte)c;
        }
        if (targetType == Double.class) {
            return (double)c;
        }
        if (targetType == Float.class) {
            return Float.valueOf(c);
        }
        return null;
    }
}

