/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.BaseVerificationPhase;
import mockit.internal.expectations.Expectation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.UnorderedVerificationPhase;
import mockit.internal.expectations.VerifiedExpectation;
import mockit.internal.expectations.invocation.ExpectedInvocation;

public final class OrderedVerificationPhase
extends BaseVerificationPhase {
    private final int expectationCount;
    private ExpectedInvocation unverifiedInvocationLeftBehind;
    private ExpectedInvocation unverifiedInvocationPrecedingVerifiedOnesLeftBehind;
    private boolean unverifiedExpectationsFixed;
    private int indexIncrement;

    OrderedVerificationPhase(@Nonnull RecordAndReplayExecution recordAndReplay, @Nonnull List<Expectation> expectationsInReplayOrder, @Nonnull List<Object> invocationInstancesInReplayOrder, @Nonnull List<Object[]> invocationArgumentsInReplayOrder) {
        super(recordAndReplay, new ArrayList<Expectation>(expectationsInReplayOrder), invocationInstancesInReplayOrder, invocationArgumentsInReplayOrder);
        this.discardExpectationsAndArgumentsAlreadyVerified();
        this.expectationCount = expectationsInReplayOrder.size();
        this.indexIncrement = 1;
    }

    private void discardExpectationsAndArgumentsAlreadyVerified() {
        for (VerifiedExpectation verified : this.recordAndReplay.executionState.verifiedExpectations) {
            int i = this.expectationsInReplayOrder.indexOf(verified.expectation);
            if (i < 0) continue;
            this.expectationsInReplayOrder.set(i, null);
        }
    }

    @Override
    @Nonnull
    protected List<ExpectedInvocation> findNonStrictExpectation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc, @Nonnull Object[] args) {
        int i = this.replayIndex;
        while (i >= 0 && i < this.expectationCount) {
            Expectation replayExpectation = (Expectation)this.expectationsInReplayOrder.get(i);
            Object replayInstance = this.invocationInstancesInReplayOrder.get(i);
            Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(i);
            i += this.indexIncrement;
            if (replayExpectation == null) continue;
            if (!this.matchInstance && this.recordAndReplay.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
                this.matchInstance = true;
            }
            if (this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance, replayArgs)) {
                this.currentExpectation = replayExpectation;
                this.indexIncrement = 1;
                this.replayIndex = i += 1 - this.indexIncrement;
                ++this.expectationBeingVerified().constraints.invocationCount;
                this.mapNewInstanceToReplacementIfApplicable(mock);
                break;
            }
            if (!this.unverifiedExpectationsFixed) {
                this.unverifiedInvocationLeftBehind = replayExpectation.invocation;
                continue;
            }
            if (this.indexIncrement <= 0) continue;
            this.recordAndReplay.setErrorThrown(replayExpectation.invocation.errorForUnexpectedInvocation());
            this.replayIndex = i;
            break;
        }
        return Collections.emptyList();
    }

    public void fixPositionOfUnverifiedExpectations() {
        if (this.unverifiedInvocationLeftBehind != null) {
            throw this.currentExpectation == null ? this.unverifiedInvocationLeftBehind.errorForUnexpectedInvocation() : this.unverifiedInvocationLeftBehind.errorForUnexpectedInvocationBeforeAnother(this.currentExpectation.invocation);
        }
        int indexOfLastUnverified = this.indexOfLastUnverifiedExpectation();
        if (indexOfLastUnverified >= 0) {
            this.replayIndex = indexOfLastUnverified;
            this.indexIncrement = -1;
            this.unverifiedExpectationsFixed = true;
        }
    }

    private int indexOfLastUnverifiedExpectation() {
        for (int i = this.expectationCount - 1; i >= 0; --i) {
            if (this.expectationsInReplayOrder.get(i) == null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void handleInvocationCountConstraint(int minInvocations, int maxInvocations) {
        Error errorThrown = this.pendingError;
        this.pendingError = null;
        if (errorThrown != null && minInvocations > 0) {
            throw errorThrown;
        }
        Expectation verifying = this.expectationBeingVerified();
        ExpectedInvocation invocation = verifying.invocation;
        this.argMatchers = invocation.arguments.getMatchers();
        int invocationCount = 1;
        while (this.replayIndex < this.expectationCount) {
            Expectation replayExpectation = (Expectation)this.expectationsInReplayOrder.get(this.replayIndex);
            if (replayExpectation != null && this.matchesCurrentVerification(replayExpectation)) {
                ++verifying.constraints.invocationCount;
                if (++invocationCount > maxInvocations) {
                    if (maxInvocations < 0) break;
                    throw replayExpectation.invocation.errorForUnexpectedInvocation();
                }
            } else if (invocationCount >= minInvocations) break;
            ++this.replayIndex;
        }
        this.argMatchers = null;
        int n = minInvocations - invocationCount;
        if (n > 0) {
            throw invocation.errorForMissingInvocations(n, Collections.<ExpectedInvocation>emptyList());
        }
        this.verifyMaxInvocations(maxInvocations);
    }

    private boolean matchesCurrentVerification(@Nonnull Expectation replayExpectation) {
        ExpectedInvocation invocation = this.expectationBeingVerified().invocation;
        Object mock = invocation.instance;
        String mockClassDesc = invocation.getClassDesc();
        String mockNameAndDesc = invocation.getMethodNameAndDescription();
        Object[] args = invocation.arguments.getValues();
        this.matchInstance = invocation.matchInstance;
        if (this.recordAndReplay.executionState.isToBeMatchedOnInstance(mock, mockNameAndDesc)) {
            this.matchInstance = true;
        }
        Object replayInstance = this.invocationInstancesInReplayOrder.get(this.replayIndex);
        Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(this.replayIndex);
        return this.matches(mock, mockClassDesc, mockNameAndDesc, args, replayExpectation, replayInstance, replayArgs);
    }

    private void verifyMaxInvocations(int maxInvocations) {
        if (maxInvocations >= 0) {
            Expectation verifying = this.expectationBeingVerified();
            int n = verifying.constraints.invocationCount - maxInvocations;
            if (n > 0) {
                Object[] replayArgs = (Object[])this.invocationArgumentsInReplayOrder.get(this.replayIndex - 1);
                throw verifying.invocation.errorForUnexpectedInvocations(replayArgs, n);
            }
        }
    }

    @Override
    @Nullable
    protected Error endVerification() {
        if (this.pendingError != null) {
            return this.pendingError;
        }
        if (this.unverifiedExpectationsFixed && this.indexIncrement > 0 && this.currentExpectation != null && this.replayIndex <= this.indexOfLastUnverifiedExpectation()) {
            ExpectedInvocation unexpectedInvocation = ((Expectation)this.expectationsInReplayOrder.get((int)this.replayIndex)).invocation;
            return unexpectedInvocation.errorForUnexpectedInvocationAfterAnother(this.currentExpectation.invocation);
        }
        if (this.unverifiedInvocationPrecedingVerifiedOnesLeftBehind != null) {
            return this.unverifiedInvocationPrecedingVerifiedOnesLeftBehind.errorForUnexpectedInvocation();
        }
        return super.endVerification();
    }

    @Override
    boolean shouldDiscardInformationAboutVerifiedInvocationOnceUsed() {
        return true;
    }

    public void checkOrderOfVerifiedInvocations(@Nonnull BaseVerificationPhase verificationPhase) {
        if (verificationPhase instanceof OrderedVerificationPhase) {
            throw new IllegalArgumentException("Invalid use of ordered verification block");
        }
        UnorderedVerificationPhase previousVerification = (UnorderedVerificationPhase)verificationPhase;
        if (previousVerification.verifiedExpectations.isEmpty()) {
            return;
        }
        if (this.indexIncrement > 0) {
            this.checkForwardOrderOfVerifiedInvocations(previousVerification);
        } else {
            this.checkBackwardOrderOfVerifiedInvocations(previousVerification);
        }
    }

    private void checkForwardOrderOfVerifiedInvocations(@Nonnull UnorderedVerificationPhase previousVerification) {
        int maxReplayIndex = this.findUnexpectedInvocationAmongVerifiedOnes(previousVerification);
        for (int i = this.replayIndex; i < maxReplayIndex; ++i) {
            Expectation expectation = (Expectation)this.expectationsInReplayOrder.get(i);
            if (expectation == null) continue;
            this.unverifiedInvocationPrecedingVerifiedOnesLeftBehind = expectation.invocation;
            break;
        }
        this.replayIndex = maxReplayIndex + 1;
        this.currentExpectation = this.replayIndex < this.expectationCount ? (Expectation)this.expectationsInReplayOrder.get(this.replayIndex) : null;
    }

    private int findUnexpectedInvocationAmongVerifiedOnes(@Nonnull UnorderedVerificationPhase previousVerification) {
        int maxReplayIndex = this.replayIndex - 1;
        for (VerifiedExpectation verified : previousVerification.verifiedExpectations) {
            if (verified.replayIndex < this.replayIndex) {
                ExpectedInvocation unexpectedInvocation = verified.expectation.invocation;
                throw this.currentExpectation == null ? unexpectedInvocation.errorForUnexpectedInvocationFoundBeforeAnother() : unexpectedInvocation.errorForUnexpectedInvocationFoundBeforeAnother(this.currentExpectation.invocation);
            }
            if (verified.replayIndex <= maxReplayIndex) continue;
            maxReplayIndex = verified.replayIndex;
        }
        return maxReplayIndex;
    }

    private void checkBackwardOrderOfVerifiedInvocations(@Nonnull UnorderedVerificationPhase previousVerification) {
        int indexOfLastUnverified = this.indexOfLastUnverifiedExpectation();
        if (indexOfLastUnverified >= 0) {
            VerifiedExpectation firstVerified = previousVerification.firstExpectationVerified();
            assert (firstVerified != null);
            if (firstVerified.replayIndex != indexOfLastUnverified + 1) {
                Expectation lastUnverified = (Expectation)this.expectationsInReplayOrder.get(indexOfLastUnverified);
                Expectation after = firstVerified.expectation;
                throw lastUnverified.invocation.errorForUnexpectedInvocationAfterAnother(after.invocation);
            }
        }
    }
}

