/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.classGeneration;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Attribute;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.reflection.GenericTypeReflection;

public abstract class BaseImplementationGenerator
extends BaseClassModifier {
    private static final int CLASS_ACCESS = 17;
    @Nonnull
    private final List<String> implementedMethods = new ArrayList<String>();
    @Nonnull
    private final String implementationClassDesc;
    @Nullable
    private String[] initialSuperInterfaces;
    protected String methodOwner;

    protected BaseImplementationGenerator(@Nonnull ClassReader classReader, @Nonnull String implementationClassName) {
        super(classReader);
        this.implementationClassDesc = implementationClassName.replace('.', '/');
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        this.methodOwner = name;
        this.initialSuperInterfaces = interfaces;
        String[] implementedInterfaces = new String[]{name};
        super.visit(version, 17, this.implementationClassDesc, signature, superName, implementedInterfaces);
        this.generateNoArgsConstructor();
    }

    private void generateNoArgsConstructor() {
        this.mw = this.cw.visitMethod(1, "<init>", "()V", null, null);
        this.mw.visitVarInsn(25, 0);
        this.mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        this.generateEmptyImplementation();
    }

    @Override
    public final void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public final void visitOuterClass(String owner, @Nullable String name, @Nullable String desc) {
    }

    @Override
    public final void visitAttribute(Attribute attr) {
    }

    @Override
    public final void visitSource(@Nullable String source, @Nullable String debug) {
    }

    @Override
    @Nullable
    public final FieldVisitor visitField(int access, String name, String desc, @Nullable String signature, @Nullable Object value) {
        return null;
    }

    @Override
    @Nullable
    public final MethodVisitor visitMethod(int access, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
        this.generateMethodImplementation(access, name, desc, signature, exceptions);
        return null;
    }

    @Override
    public final void visitEnd() {
        assert (this.initialSuperInterfaces != null);
        for (String superInterface : this.initialSuperInterfaces) {
            new MethodGeneratorForImplementedSuperInterface(superInterface);
        }
    }

    protected final void generateMethodImplementation(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        String methodNameAndDesc;
        if (!Modifier.isStatic(access) && !this.implementedMethods.contains(methodNameAndDesc = name + desc)) {
            this.generateMethodBody(access, name, desc, signature, exceptions);
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    protected abstract void generateMethodBody(int var1, @Nonnull String var2, @Nonnull String var3, @Nullable String var4, @Nullable String[] var5);

    protected final boolean isOverrideOfMethodFromSuperInterface(@Nonnull String name, @Nonnull String desc) {
        if (!this.implementedMethods.isEmpty()) {
            int p = desc.lastIndexOf(41);
            String descNoReturnType = desc.substring(0, p + 1);
            for (String implementedMethod : this.implementedMethods) {
                if (!BaseImplementationGenerator.sameMethodName(implementedMethod, name) || !implementedMethod.contains(descNoReturnType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean sameMethodName(@Nonnull String implementedMethod, @Nonnull String name) {
        return implementedMethod.startsWith(name) && implementedMethod.charAt(name.length()) == '(';
    }

    @Nullable
    protected final String getSubInterfaceOverride(@Nonnull GenericTypeReflection genericTypeMap, @Nonnull String name, @Nonnull String genericSignature) {
        if (!this.implementedMethods.isEmpty()) {
            GenericTypeReflection.GenericSignature parsedSignature = genericTypeMap.parseSignature(genericSignature);
            for (String implementedMethod : this.implementedMethods) {
                if (!BaseImplementationGenerator.sameMethodName(implementedMethod, name) || !parsedSignature.satisfiesSignature(implementedMethod)) continue;
                return implementedMethod;
            }
        }
        return null;
    }

    private final class MethodGeneratorForImplementedSuperInterface
    extends ClassVisitor {
        private String[] superInterfaces;

        MethodGeneratorForImplementedSuperInterface(String interfaceName) {
            ClassFile.visitClass(interfaceName, this);
        }

        @Override
        public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            BaseImplementationGenerator.this.methodOwner = name;
            this.superInterfaces = interfaces;
        }

        @Override
        @Nullable
        public FieldVisitor visitField(int access, String name, String desc, @Nullable String signature, @Nullable Object value) {
            return null;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String desc, @Nullable String signature, @Nullable String[] exceptions) {
            BaseImplementationGenerator.this.generateMethodImplementation(access, name, desc, signature, exceptions);
            return null;
        }

        @Override
        public void visitEnd() {
            for (String superInterface : this.superInterfaces) {
                new MethodGeneratorForImplementedSuperInterface(superInterface);
            }
        }
    }
}

