/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.ClassReader;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.capturing.CaptureTransformer;
import mockit.internal.capturing.CapturedType;
import mockit.internal.startup.Startup;
import mockit.internal.state.TestRun;

public abstract class CaptureOfImplementations<M> {
    protected CaptureOfImplementations() {
    }

    public final void makeSureAllSubtypesAreModified(@Nonnull Class<?> baseType, boolean registerCapturedClasses, @Nullable M typeMetadata) {
        CapturedType captureMetadata = new CapturedType(baseType);
        this.redefineClassesAlreadyLoaded(captureMetadata, baseType, typeMetadata);
        this.createCaptureTransformer(captureMetadata, registerCapturedClasses, typeMetadata);
    }

    private void redefineClassesAlreadyLoaded(@Nonnull CapturedType captureMetadata, @Nonnull Class<?> baseType, @Nullable M typeMetadata) {
        Class[] classesLoaded;
        for (Class aClass : classesLoaded = Startup.instrumentation().getAllLoadedClasses()) {
            if (!captureMetadata.isToBeCaptured(aClass)) continue;
            this.redefineClass(aClass, baseType, typeMetadata);
        }
    }

    public void redefineClass(@Nonnull Class<?> realClass, @Nonnull Class<?> baseType, @Nullable M typeMetadata) {
        if (!TestRun.mockFixture().containsRedefinedClass(realClass)) {
            ClassReader classReader;
            try {
                classReader = ClassFile.createReaderOrGetFromCache(realClass);
            }
            catch (ClassFile.NotFoundException ignore) {
                return;
            }
            TestRun.ensureThatClassIsInitialized(realClass);
            BaseClassModifier modifier = this.createModifier(realClass.getClassLoader(), classReader, baseType, typeMetadata);
            classReader.accept(modifier, 4);
            if (modifier.wasModified()) {
                byte[] modifiedClass = modifier.toByteArray();
                this.redefineClass(realClass, modifiedClass);
            }
        }
    }

    @Nonnull
    protected abstract BaseClassModifier createModifier(@Nullable ClassLoader var1, @Nonnull ClassReader var2, @Nonnull Class<?> var3, @Nullable M var4);

    protected abstract void redefineClass(@Nonnull Class<?> var1, @Nonnull byte[] var2);

    private void createCaptureTransformer(@Nonnull CapturedType captureMetadata, boolean registerCapturedClasses, @Nullable M typeMetadata) {
        CaptureTransformer<M> transformer = new CaptureTransformer<M>(captureMetadata, this, registerCapturedClasses, typeMetadata);
        Startup.instrumentation().addTransformer(transformer, true);
        TestRun.mockFixture().addCaptureTransformer(transformer);
    }
}

