/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.Label;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.MethodWriter;
import mockit.external.asm.Type;
import mockit.internal.MockingBridge;
import mockit.internal.SuperConstructorCollector;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.TypeConversion;

public class BaseClassModifier
extends ClassVisitor {
    private static final int METHOD_ACCESS_MASK = 64255;
    protected static final Type VOID_TYPE = Type.getType("Ljava/lang/Void;");
    @Nonnull
    protected final MethodVisitor methodAnnotationsVisitor = new MethodVisitor(){

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return BaseClassModifier.this.mw.visitAnnotation(desc, visible);
        }

        @Override
        public void visitLocalVariable(@Nonnull String name, @Nonnull String desc, String signature, @Nonnull Label start, @Nonnull Label end, int index) {
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }
    };
    @Nonnull
    protected final ClassWriter cw = (ClassWriter)this.cv;
    protected MethodWriter mw;
    protected boolean useMockingBridge;
    protected String superClassName;
    protected String classDesc;
    protected int methodAccess;
    protected String methodName;
    protected String methodDesc;

    protected BaseClassModifier(@Nonnull ClassReader classReader) {
        super(new ClassWriter(classReader));
    }

    protected final void setUseMockingBridge(@Nullable ClassLoader classLoader) {
        this.useMockingBridge = ClassLoad.isClassLoaderWithNoDirectAccess(classLoader);
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        int modifiedVersion = version;
        int originalVersion = version & 0xFFFF;
        if (originalVersion < 49) {
            modifiedVersion = 49;
        }
        this.cw.visit(modifiedVersion, access, name, signature, superName, interfaces);
        this.superClassName = superName;
        this.classDesc = name;
    }

    protected final void startModifiedMethodVersion(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        this.mw = this.cw.visitMethod(access & 0xFAFF, name, desc, signature, exceptions);
        this.methodAccess = access;
        this.methodName = name;
        this.methodDesc = desc;
        if (Modifier.isNative(access)) {
            TestRun.mockFixture().addRedefinedClassWithNativeMethods(this.classDesc);
        }
    }

    public final boolean wasModified() {
        return this.methodName != null;
    }

    protected final void generateCallToSuperConstructor() {
        if (this.superClassName != null) {
            String constructorDesc;
            this.mw.visitVarInsn(25, 0);
            if ("java/lang/Object".equals(this.superClassName)) {
                constructorDesc = "()V";
            } else {
                constructorDesc = SuperConstructorCollector.INSTANCE.findConstructor(this.classDesc, this.superClassName);
                for (Type paramType : Type.getArgumentTypes(constructorDesc)) {
                    this.pushDefaultValueForType(paramType);
                }
            }
            this.mw.visitMethodInsn(183, this.superClassName, "<init>", constructorDesc, false);
        }
    }

    protected final void generateReturnWithObjectAtTopOfTheStack(@Nonnull String mockedMethodDesc) {
        Type returnType = Type.getReturnType(mockedMethodDesc);
        TypeConversion.generateCastFromObject(this.mw, returnType);
        this.mw.visitInsn(returnType.getOpcode(172));
    }

    protected final boolean generateCodeToPassThisOrNullIfStaticMethod() {
        return BaseClassModifier.generateCodeToPassThisOrNullIfStaticMethod(this.mw, this.methodAccess);
    }

    public static boolean generateCodeToPassThisOrNullIfStaticMethod(@Nonnull MethodWriter mw, int access) {
        boolean isStatic = Modifier.isStatic(access);
        if (isStatic) {
            mw.visitInsn(1);
        } else {
            mw.visitVarInsn(25, 0);
        }
        return isStatic;
    }

    public static void generateCodeToCreateArrayOfObject(@Nonnull MethodWriter mw, int arrayLength) {
        mw.visitIntInsn(17, arrayLength);
        mw.visitTypeInsn(189, "java/lang/Object");
    }

    public static void generateCodeToFillArrayWithParameterValues(@Nonnull MethodWriter mw, @Nonnull Type[] parameterTypes, int initialArrayIndex, int initialParameterIndex) {
        int i = initialArrayIndex;
        int j = initialParameterIndex;
        for (Type parameterType : parameterTypes) {
            mw.visitInsn(89);
            mw.visitIntInsn(17, i++);
            mw.visitVarInsn(parameterType.getOpcode(21), j);
            TypeConversion.generateCastToObject(mw, parameterType);
            mw.visitInsn(83);
            j += parameterType.getSize();
        }
    }

    protected final void generateCodeToObtainInstanceOfMockingBridge(@Nonnull MockingBridge mockingBridge) {
        String hostClassName = MockingBridge.getHostClassName();
        this.mw.visitFieldInsn(178, hostClassName, mockingBridge.id, "Ljava/lang/reflect/InvocationHandler;");
    }

    protected final void generateCodeToFillArrayElement(int arrayIndex, @Nullable Object value) {
        this.mw.visitInsn(89);
        this.mw.visitIntInsn(17, arrayIndex);
        if (value == null) {
            this.mw.visitInsn(1);
        } else if (value instanceof Integer) {
            this.mw.visitIntInsn(17, (Integer)value);
            this.mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (value instanceof Boolean) {
            this.mw.visitInsn((Boolean)value != false ? 4 : 3);
            this.mw.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else {
            this.mw.visitLdcInsn(value);
        }
        this.mw.visitInsn(83);
    }

    private void pushDefaultValueForType(@Nonnull Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mw.visitInsn(3);
                break;
            }
            case 7: {
                this.mw.visitInsn(9);
                break;
            }
            case 6: {
                this.mw.visitInsn(11);
                break;
            }
            case 8: {
                this.mw.visitInsn(14);
                break;
            }
            case 9: {
                this.generateCreationOfEmptyArray(type);
                break;
            }
            default: {
                this.mw.visitInsn(1);
            }
        }
    }

    private void generateCreationOfEmptyArray(@Nonnull Type arrayType) {
        int dimensions = arrayType.getDimensions();
        for (int dimension = 0; dimension < dimensions; ++dimension) {
            this.mw.visitInsn(3);
        }
        if (dimensions > 1) {
            this.mw.visitMultiANewArrayInsn(arrayType.getDescriptor(), dimensions);
            return;
        }
        Type elementType = arrayType.getElementType();
        int elementSort = elementType.getSort();
        if (elementSort == 10) {
            this.mw.visitTypeInsn(189, elementType.getInternalName());
        } else {
            int typ = BaseClassModifier.getArrayElementTypeCode(elementSort);
            this.mw.visitIntInsn(188, typ);
        }
    }

    private static int getArrayElementTypeCode(int elementSort) {
        switch (elementSort) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 9;
            }
            case 5: {
                return 10;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 11;
            }
        }
        return 7;
    }

    protected final void generateCallToInvocationHandler() {
        this.mw.visitMethodInsn(185, "java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", true);
    }

    protected final void generateEmptyImplementation(@Nonnull String desc) {
        Type returnType = Type.getReturnType(desc);
        this.pushDefaultValueForType(returnType);
        this.mw.visitInsn(returnType.getOpcode(172));
        this.mw.visitMaxs(1, 0);
    }

    protected final void generateEmptyImplementation() {
        this.mw.visitInsn(177);
        this.mw.visitMaxs(1, 0);
    }

    @Nonnull
    protected final MethodVisitor copyOriginalImplementationCode(boolean disregardCallToSuper) {
        if (disregardCallToSuper) {
            return new DynamicConstructorModifier();
        }
        if (Modifier.isNative(this.methodAccess)) {
            this.generateEmptyImplementation(this.methodDesc);
            return this.methodAnnotationsVisitor;
        }
        return new DynamicModifier();
    }

    private final class DynamicConstructorModifier
    extends DynamicModifier {
        private boolean pendingCallToConstructorOfSameClass;
        private boolean callToAnotherConstructorAlreadyDisregarded;

        private DynamicConstructorModifier() {
        }

        @Override
        public void visitTypeInsn(int opcode, @Nonnull String type) {
            if (!this.callToAnotherConstructorAlreadyDisregarded && opcode == 187 && type.equals(BaseClassModifier.this.classDesc)) {
                this.pendingCallToConstructorOfSameClass = true;
            }
            BaseClassModifier.this.mw.visitTypeInsn(opcode, type);
        }

        @Override
        public void visitMethodInsn(int opcode, @Nonnull String owner, @Nonnull String name, @Nonnull String desc, boolean itf) {
            if (this.pendingCallToConstructorOfSameClass) {
                if (opcode == 183 && "<init>".equals(name) && owner.equals(BaseClassModifier.this.classDesc)) {
                    BaseClassModifier.this.mw.visitMethodInsn(183, owner, name, desc, itf);
                    this.pendingCallToConstructorOfSameClass = false;
                }
            } else if (this.callToAnotherConstructorAlreadyDisregarded || opcode != 183 || !"<init>".equals(name) || !owner.equals(BaseClassModifier.this.superClassName) && !owner.equals(BaseClassModifier.this.classDesc)) {
                BaseClassModifier.this.mw.visitMethodInsn(opcode, owner, name, desc, itf);
            } else {
                this.callToAnotherConstructorAlreadyDisregarded = true;
            }
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (this.callToAnotherConstructorAlreadyDisregarded) {
                BaseClassModifier.this.mw.visitTryCatchBlock(start, end, handler, type);
            }
        }
    }

    private class DynamicModifier
    extends MethodVisitor {
        DynamicModifier() {
            super(BaseClassModifier.this.mw);
        }

        @Override
        public final void visitLocalVariable(@Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nonnull Label start, @Nonnull Label end, int index) {
            if (end.position > 0 && start.position > end.position) {
                start.position = end.position;
            }
            if (start.position > 0 && end.position > 0) {
                BaseClassModifier.this.mw.visitLocalVariable(name, desc, signature, start, end, index);
            }
        }
    }
}

