/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit4.internal;

import javax.annotation.Nonnull;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import mockit.coverage.CodeCoverage;
import mockit.coverage.testRedundancy.JUnitListener;
import mockit.integration.internal.TestRunnerDecorator;
import mockit.internal.mockups.MockInvocation;
import mockit.internal.state.TestRun;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public final class RunNotifierDecorator
extends MockUp<RunNotifier> {
    @Mock
    public static void fireTestRunStarted(Invocation invocation, Description description) {
        RunNotifier it = (RunNotifier)invocation.getInvokedInstance();
        if (CodeCoverage.active()) {
            it.addListener((RunListener)new JUnitListener());
        }
        RunNotifierDecorator.prepareToProceed(invocation);
        it.fireTestRunStarted(description);
    }

    private static void prepareToProceed(@Nonnull Invocation invocation) {
        ((MockInvocation)invocation).prepareToProceedFromNonRecursiveMock();
    }

    @Mock
    public void fireTestStarted(Invocation invocation, Description description) {
        Class newTestClass;
        Class<?> currentTestClass = TestRun.getCurrentTestClass();
        if (currentTestClass != null && !currentTestClass.isAssignableFrom(newTestClass = description.getTestClass())) {
            TestRunnerDecorator.cleanUpMocksFromPreviousTestClass();
        }
        RunNotifierDecorator.prepareToProceed(invocation);
        RunNotifier it = (RunNotifier)invocation.getInvokedInstance();
        it.fireTestStarted(description);
    }

    @Mock
    public static void fireTestRunFinished(Invocation invocation, Result result) {
        TestRun.enterNoMockingZone();
        try {
            TestRunnerDecorator.cleanUpAllMocks();
            RunNotifierDecorator.prepareToProceed(invocation);
            RunNotifier it = (RunNotifier)invocation.getInvokedInstance();
            it.fireTestRunFinished(result);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }
}

