/*
 * Decompiled with CFR 0.152.
 */
package mockit;

import java.lang.reflect.Modifier;
import mockit.internal.classGeneration.ConcreteSubclass;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.reflection.EmptyProxy;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.reflection.MethodReflection;
import mockit.internal.util.ClassLoad;

public final class Deencapsulation {
    private Deencapsulation() {
    }

    public static <T> T getField(Object objectWithField, String fieldName) {
        return FieldReflection.getField(objectWithField.getClass(), fieldName, objectWithField);
    }

    public static <T> T getField(Object objectWithField, Class<T> fieldType) {
        return FieldReflection.getField(objectWithField.getClass(), fieldType, objectWithField);
    }

    public static <T> T getField(Class<?> classWithStaticField, String fieldName) {
        return FieldReflection.getField(classWithStaticField, fieldName, null);
    }

    public static <T> T getField(Class<?> classWithStaticField, Class<T> fieldType) {
        return FieldReflection.getField(classWithStaticField, fieldType, null);
    }

    public static void setField(Object objectWithField, String fieldName, Object fieldValue) {
        FieldReflection.setField(objectWithField.getClass(), objectWithField, fieldName, fieldValue);
    }

    public static void setField(Object objectWithField, Object fieldValue) {
        FieldReflection.setField(objectWithField.getClass(), objectWithField, null, fieldValue);
    }

    public static void setField(Class<?> classWithStaticField, String fieldName, Object fieldValue) {
        FieldReflection.setField(classWithStaticField, null, fieldName, fieldValue);
    }

    public static void setField(Class<?> classWithStaticField, Object fieldValue) {
        FieldReflection.setField(classWithStaticField, null, null, fieldValue);
    }

    public static <T> T invoke(Object objectWithMethod, String methodName, Class<?>[] parameterTypes, Object ... methodArgs) {
        Class<?> theClass = objectWithMethod.getClass();
        return MethodReflection.invoke(theClass, objectWithMethod, methodName, parameterTypes, methodArgs);
    }

    public static <T> T invoke(Object objectWithMethod, String methodName, Object ... nonNullArgs) {
        Class<?> theClass = objectWithMethod.getClass();
        return MethodReflection.invoke(theClass, objectWithMethod, methodName, nonNullArgs);
    }

    public static <T> T invoke(Class<?> classWithStaticMethod, String methodName, Class<?>[] parameterTypes, Object ... methodArgs) {
        return MethodReflection.invoke(classWithStaticMethod, null, methodName, parameterTypes, methodArgs);
    }

    public static <T> T invoke(Class<?> classWithStaticMethod, String methodName, Object ... nonNullArgs) {
        return MethodReflection.invoke(classWithStaticMethod, null, methodName, nonNullArgs);
    }

    public static <T> T invoke(String classWithStaticMethod, String methodName, Object ... nonNullArgs) {
        Class theClass = ClassLoad.loadClass(classWithStaticMethod);
        return MethodReflection.invoke(theClass, null, methodName, nonNullArgs);
    }

    public static <T> T newInstance(String className, Class<?>[] parameterTypes, Object ... initArgs) {
        return ConstructorReflection.newInstance(className, parameterTypes, initArgs);
    }

    public static <T> T newInstance(Class<? extends T> classToInstantiate, Class<?>[] parameterTypes, Object ... initArgs) {
        return ConstructorReflection.newInstance(classToInstantiate, parameterTypes, initArgs);
    }

    public static <T> T newInstance(String className, Object ... nonNullArgs) {
        return ConstructorReflection.newInstance(className, nonNullArgs);
    }

    public static <T> T newInstance(Class<? extends T> classToInstantiate, Object ... nonNullArgs) {
        return ConstructorReflection.newInstance(classToInstantiate, nonNullArgs);
    }

    public static <T> T newInnerInstance(String innerClassSimpleName, Object outerClassInstance, Object ... nonNullArgs) {
        return ConstructorReflection.newInnerInstance(innerClassSimpleName, outerClassInstance, nonNullArgs);
    }

    public static <T> T newInnerInstance(Class<? extends T> innerClassToInstantiate, Object outerClassInstance, Object ... nonNullArgs) {
        return ConstructorReflection.newInnerInstance(innerClassToInstantiate, outerClassInstance, nonNullArgs);
    }

    public static <T> T newUninitializedInstance(Class<? extends T> classToInstantiate) {
        if (classToInstantiate.isInterface()) {
            Object instance = EmptyProxy.Impl.newEmptyProxy(classToInstantiate.getClassLoader(), classToInstantiate);
            return (T)instance;
        }
        if (Modifier.isAbstract(classToInstantiate.getModifiers())) {
            classToInstantiate = new ConcreteSubclass(classToInstantiate).generateClass();
        }
        return ConstructorReflection.newUninitializedInstance(classToInstantiate);
    }
}

