/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.transaction.Synchronization;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.Status;
import org.jboss.weld.event.TransactionSynchronizedRunnable;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionalObserverNotifier
extends ObserverNotifier {
    private final TransactionServices transactionServices;

    protected TransactionalObserverNotifier(TypeSafeObserverResolver resolver, ServiceRegistry services) {
        super(resolver, services);
        this.transactionServices = (TransactionServices)services.get(TransactionServices.class);
    }

    @Override
    protected <T> void notifyObserver(T event, ObserverMethod<? super T> observer) {
        if (this.immediateDispatch(observer)) {
            super.notifyObserver(event, observer);
        } else {
            this.deferNotification(event, observer);
        }
    }

    private boolean immediateDispatch(ObserverMethod<?> observer) {
        return TransactionPhase.IN_PROGRESS.equals((Object)observer.getTransactionPhase()) || this.transactionServices == null || !this.transactionServices.isTransactionActive();
    }

    private <T> void deferNotification(T event, ObserverMethod<? super T> observer) {
        DeferredEventNotification<? super T> deferredEvent = new DeferredEventNotification<T>(event, observer);
        TransactionPhase transactionPhase = observer.getTransactionPhase();
        if (transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, true));
        } else if (transactionPhase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, false));
        } else if (transactionPhase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, Status.SUCCESS));
        } else if (transactionPhase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, Status.FAILURE));
        }
    }
}

