/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.SessionContext;
import org.jboss.weld.conversation.AbstractConversationManager;
import org.jboss.weld.jsf.JsfHelper;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.JsfMessage;
import org.jboss.weld.servlet.BeanProvider;
import org.slf4j.cal10n.LocLogger;

public class WeldPhaseListener
implements PhaseListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.JSF);

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.beforeRestoreView(phaseEvent.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.afterRenderResponse(phaseEvent.getFacesContext());
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.afterResponseComplete(phaseEvent.getFacesContext(), phaseEvent.getPhaseId());
        }
    }

    private void beforeRestoreView(FacesContext facesContext) {
        log.trace((Enum)JsfMessage.INITIATING_CONVERSATION, new Object[]{"Restore View"});
        this.initiateSessionAndConversation(facesContext);
    }

    private void afterRenderResponse(FacesContext facesContext) {
        SessionContext sessionContext = ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).getSessionContext();
        ConversationContext conversationContext = ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).getConversationContext();
        if (sessionContext.isActive()) {
            log.trace((Enum)JsfMessage.CLEANING_UP_CONVERSATION, new Object[]{"Render Response", "response complete"});
            BeanProvider.conversationManager(JsfHelper.getServletContext(facesContext)).cleanupConversation();
            conversationContext.setActive(false);
        } else {
            log.trace((Enum)JsfMessage.SKIPPING_CLEANING_UP_CONVERSATION, new Object[]{"Render Response", "session has been terminated"});
        }
    }

    private void afterResponseComplete(FacesContext facesContext, PhaseId phaseId) {
        SessionContext sessionContext = ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).getSessionContext();
        if (sessionContext.isActive()) {
            log.trace((Enum)JsfMessage.CLEANING_UP_CONVERSATION, new Object[]{phaseId, "the response has been marked complete"});
            BeanProvider.conversationManager(JsfHelper.getServletContext(facesContext)).cleanupConversation();
        } else {
            log.trace((Enum)JsfMessage.SKIPPING_CLEANING_UP_CONVERSATION, new Object[]{phaseId, "session has been terminated"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateSessionAndConversation(FacesContext facesContext) {
        ServletContext servletContext = JsfHelper.getServletContext(facesContext);
        AbstractConversationManager conversationManager = (AbstractConversationManager)BeanProvider.conversationManager(servletContext);
        HttpSession session = JsfHelper.getHttpSession(facesContext);
        BeanProvider.httpSessionManager(servletContext).setSession(session);
        try {
            conversationManager.beginOrRestoreConversation(JsfHelper.getConversationId(facesContext));
        }
        finally {
            String cid = BeanProvider.conversation(servletContext).getUnderlyingId();
            ConversationContext conversationContext = ((ContextLifecycle)Container.instance().services().get(ContextLifecycle.class)).getConversationContext();
            conversationContext.setBeanStore(conversationManager.getBeanStore(cid));
            conversationContext.setActive(true);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

