/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.headers.object.range;

import java.util.Arrays;
import org.javaswift.joss.headers.Header;

public abstract class AbstractRange
extends Header {
    public String RANGE_HEADER_NAME = "Range";
    public String RANGE_HEADER_VALUE_PREFIX = "bytes=";
    protected long offset;
    protected long length;

    protected AbstractRange(long offset, long length) {
        this.offset = offset;
        this.length = length;
    }

    @Override
    public String getHeaderValue() {
        return this.RANGE_HEADER_VALUE_PREFIX + (this.offset >= 0L ? Long.toString(this.offset) : "") + "-" + (this.length >= 0L ? Long.toString(this.length) : "");
    }

    @Override
    public String getHeaderName() {
        return this.RANGE_HEADER_NAME;
    }

    public abstract long getFrom(int var1);

    public abstract long getTo(int var1);

    public byte[] copy(byte[] original) {
        return Arrays.copyOfRange(original, (int)this.getFrom(original.length), (int)this.getTo(original.length));
    }
}

