/*
 * Decompiled with CFR 0.152.
 */
package org.javaswift.joss.command.impl.factory;

import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.javaswift.joss.client.factory.TempUrlHashPrefixSource;
import org.javaswift.joss.command.impl.account.AccountInformationCommandImpl;
import org.javaswift.joss.command.impl.account.AccountMetadataCommandImpl;
import org.javaswift.joss.command.impl.account.HashPasswordCommandImpl;
import org.javaswift.joss.command.impl.account.ListContainersCommandImpl;
import org.javaswift.joss.command.impl.account.TenantCommandImpl;
import org.javaswift.joss.command.impl.factory.ContainerCommandFactoryImpl;
import org.javaswift.joss.command.shared.account.AccountInformationCommand;
import org.javaswift.joss.command.shared.account.AccountMetadataCommand;
import org.javaswift.joss.command.shared.account.HashPasswordCommand;
import org.javaswift.joss.command.shared.account.ListContainersCommand;
import org.javaswift.joss.command.shared.account.TenantCommand;
import org.javaswift.joss.command.shared.factory.AccountCommandFactory;
import org.javaswift.joss.command.shared.factory.ContainerCommandFactory;
import org.javaswift.joss.command.shared.identity.AuthenticationCommand;
import org.javaswift.joss.headers.Header;
import org.javaswift.joss.instructions.ListInstructions;
import org.javaswift.joss.model.Access;
import org.javaswift.joss.model.Account;

public class AccountCommandFactoryImpl
implements AccountCommandFactory {
    private final ContainerCommandFactory containerCommandFactory;
    private final HttpClient httpClient;
    private Access access;
    private final AuthenticationCommand authCommand;
    private String publicHost;
    private String privateHost;
    private TempUrlHashPrefixSource tempUrlHashPrefixSource;
    private Character delimiter;

    public AccountCommandFactoryImpl(HttpClient httpClient, Access access, AuthenticationCommand authCommand, TempUrlHashPrefixSource tempUrlHashPrefixSource, Character delimiter) {
        this.httpClient = httpClient;
        this.access = access;
        this.authCommand = authCommand;
        this.containerCommandFactory = new ContainerCommandFactoryImpl(this);
        this.tempUrlHashPrefixSource = tempUrlHashPrefixSource;
        this.delimiter = delimiter;
    }

    @Override
    public void setPublicHost(String publicHost) {
        this.publicHost = publicHost;
    }

    @Override
    public void setPrivateHost(String privateHost) {
        this.privateHost = privateHost;
    }

    @Override
    public String getPublicHost() {
        return this.publicHost == null ? this.access.getPublicURL() : this.publicHost;
    }

    @Override
    public String getPrivateHost() {
        return this.privateHost == null ? this.access.getPublicURL() : this.privateHost;
    }

    @Override
    public String getOriginalHost() {
        return this.access.getPublicURL();
    }

    @Override
    public Access authenticate() {
        this.access = (Access)this.authCommand.call();
        return this.access;
    }

    @Override
    public AccountInformationCommand createAccountInformationCommand(Account account) {
        return new AccountInformationCommandImpl(account, this.httpClient, this.access);
    }

    @Override
    public AccountMetadataCommand createAccountMetadataCommand(Account account, Collection<? extends Header> headers) {
        return new AccountMetadataCommandImpl(account, this.httpClient, this.access, headers);
    }

    @Override
    public ListContainersCommand createListContainersCommand(Account account, ListInstructions listInstructions) {
        return new ListContainersCommandImpl(account, this.httpClient, this.access, listInstructions);
    }

    @Override
    public TenantCommand createTenantCommand(Account account) {
        return new TenantCommandImpl(account, this.httpClient, this.access, this.authCommand.getUrl());
    }

    @Override
    public HashPasswordCommand createHashPasswordCommand(Account account, String hashPassword) {
        return new HashPasswordCommandImpl(account, this.httpClient, this.access, hashPassword);
    }

    @Override
    public ContainerCommandFactory getContainerCommandFactory() {
        return this.containerCommandFactory;
    }

    @Override
    public boolean isTenantSupplied() {
        return this.access.isTenantSupplied();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public Access getAccess() {
        return this.access;
    }

    public TempUrlHashPrefixSource getTempUrlHashPrefixSource() {
        return this.tempUrlHashPrefixSource;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }
}

