/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.util.Map;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.SingletonExternalizer;
import org.infinispan.commons.marshall.SuppliedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jcache.embedded.ExternalizerIds;
import org.infinispan.jcache.embedded.functions.GetAndPut;
import org.infinispan.jcache.embedded.functions.GetAndRemove;
import org.infinispan.jcache.embedded.functions.GetAndReplace;
import org.infinispan.jcache.embedded.functions.Invoke;
import org.infinispan.jcache.embedded.functions.MutableEntrySnapshot;
import org.infinispan.jcache.embedded.functions.Put;
import org.infinispan.jcache.embedded.functions.PutIfAbsent;
import org.infinispan.jcache.embedded.functions.ReadWithExpiry;
import org.infinispan.jcache.embedded.functions.Remove;
import org.infinispan.jcache.embedded.functions.RemoveConditionally;
import org.infinispan.jcache.embedded.functions.Replace;
import org.infinispan.jcache.embedded.functions.ReplaceConditionally;
import org.infinispan.lifecycle.ModuleLifecycle;

public class LifecycleCallbacks
implements ModuleLifecycle {
    private static Log log = LogFactory.getLog(LifecycleCallbacks.class);

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        Map map = globalConfiguration.serialization().advancedExternalizers();
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.READ_WITH_EXPIRY, ReadWithExpiry.class, ReadWithExpiry::new));
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.GET_AND_PUT, GetAndPut.class, GetAndPut::new));
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.GET_AND_REPLACE, GetAndReplace.class, GetAndReplace::new));
        LifecycleCallbacks.add(map, new Invoke.Externalizer());
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.PUT, Put.class, Put::new));
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.PUT_IF_ABSENT, PutIfAbsent.class, PutIfAbsent::new));
        LifecycleCallbacks.add(map, new SingletonExternalizer(ExternalizerIds.REMOVE, Remove.getInstance()));
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.REMOVE_CONDITIONALLY, RemoveConditionally.class, RemoveConditionally::new));
        LifecycleCallbacks.add(map, new SuppliedExternalizer(ExternalizerIds.REPLACE, Replace.class, Replace::new));
        LifecycleCallbacks.add(map, new SingletonExternalizer(ExternalizerIds.GET_AND_REMOVE, GetAndRemove.getInstance()));
        LifecycleCallbacks.add(map, new ReplaceConditionally.Externalizer());
        if (this.canLoad("javax.cache.processor.MutableEntry", MutableEntrySnapshot.Externalizer.class.getClassLoader())) {
            LifecycleCallbacks.add(map, new MutableEntrySnapshot.Externalizer());
        }
    }

    private boolean canLoad(String className, ClassLoader classLoader) {
        try {
            Util.loadClassStrict((String)className, (ClassLoader)classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            log.tracef((Throwable)e, "Cannot load " + className, new Object[0]);
            return false;
        }
    }

    private static void add(Map<Integer, AdvancedExternalizer<?>> externalizerMap, AdvancedExternalizer<?> externalizer) {
        externalizerMap.put(externalizer.getId(), externalizer);
    }
}

