/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.lib.tar.RB;

public class TarFileOutputStream {
    public static boolean debug = Boolean.getBoolean("DEBUG");
    protected int blocksPerRecord;
    protected long bytesWritten = 0L;
    private OutputStream writeStream;
    private File targetFile;
    private File writeFile;
    public byte[] writeBuffer;
    public static final byte[] ZERO_BLOCK = new byte[512];

    public TarFileOutputStream(File file) throws IOException {
        this(file, 0);
    }

    public TarFileOutputStream(File file, int n) throws IOException {
        this(file, n, 20);
    }

    public TarFileOutputStream(File file, int n, int n2) throws IOException {
        this.blocksPerRecord = n2;
        this.targetFile = file;
        this.writeFile = new File(file.getParentFile(), file.getName() + "-partial");
        if (this.writeFile.exists()) {
            throw new IOException(RB.move_work_file.getString(this.writeFile.getAbsolutePath()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException(RB.cant_overwrite.getString(file.getAbsolutePath()));
        }
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2.exists() && file2.isDirectory()) {
            if (!file2.canWrite()) {
                throw new IOException(RB.cant_write_dir.getString(file2.getAbsolutePath()));
            }
        } else {
            throw new IOException(RB.no_parent_dir.getString(file2.getAbsolutePath()));
        }
        this.writeBuffer = new byte[n2 * 512];
        switch (n) {
            case 0: {
                this.writeStream = new FileOutputStream(this.writeFile);
                break;
            }
            case 1: {
                this.writeStream = new GZIPOutputStream((OutputStream)new FileOutputStream(this.writeFile), this.writeBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.compression_unknown.getString(n));
            }
        }
    }

    public void write(byte[] byArray, int n) throws IOException {
        this.writeStream.write(byArray, 0, n);
        this.bytesWritten += (long)n;
    }

    public void write(int n) throws IOException {
        this.write(this.writeBuffer, n);
    }

    public void writeBlock(byte[] byArray) throws IOException {
        if (byArray.length != 512) {
            throw new IllegalArgumentException(RB.bad_block_write_len.getString(byArray.length));
        }
        this.write(byArray, byArray.length);
    }

    public void writePadBlocks(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.write(ZERO_BLOCK, ZERO_BLOCK.length);
        }
    }

    public void writePadBlock() throws IOException {
        this.writePadBlocks(1);
    }

    public int bytesLeftInBlock() {
        int n = (int)(this.bytesWritten % 512L);
        if (n == 0) {
            return 0;
        }
        return 512 - n;
    }

    public void assertAtBlockBoundary() {
        if (this.bytesLeftInBlock() != 0) {
            throw new IllegalArgumentException(RB.illegal_block_boundary.getString(Long.toString(this.bytesWritten)));
        }
    }

    public void padCurrentBlock() throws IOException {
        int n = this.bytesLeftInBlock();
        if (n == 0) {
            return;
        }
        this.write(ZERO_BLOCK, n);
        this.assertAtBlockBoundary();
    }

    public void flush() throws IOException {
        this.writeStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.writeStream == null) {
            return;
        }
        try {
            this.writeStream.close();
            if (!this.writeFile.delete()) {
                throw new IOException(RB.workfile_delete_fail.getString(this.writeFile.getAbsolutePath()));
            }
            Object var2_1 = null;
            this.writeStream = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.writeStream = null;
            throw throwable;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void finish() throws IOException {
        try {
            long l = this.bytesWritten / 512L + 2L;
            if (l % (long)this.blocksPerRecord != 0L) {
                l = (l / (long)this.blocksPerRecord + 1L) * (long)this.blocksPerRecord;
            }
            int n = (int)(l - this.bytesWritten / 512L);
            if (debug) {
                System.out.println(RB.pad_block_write.getString(n));
            }
            this.writePadBlocks(n);
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        this.writeStream.close();
        this.writeFile.renameTo(this.targetFile);
    }

    public static interface Compression {
        public static final int NO_COMPRESSION = 0;
        public static final int GZIP_COMPRESSION = 1;
        public static final int DEFAULT_COMPRESSION = 0;
        public static final int DEFAULT_BLOCKS_PER_RECORD = 20;
    }
}

