/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public class BlobInputStream
extends InputStream {
    final JDBCBlobClient blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    int streamBlockSize;

    public BlobInputStream(JDBCBlobClient jDBCBlobClient, long l, long l2, int n) throws SQLException {
        if (!JDBCBlobClient.isInLimits(jDBCBlobClient.length(), l, l2)) {
            throw Util.outOfRangeArgument();
        }
        this.blob = jDBCBlobClient;
        this.availableLength = l + l2;
        this.currentPosition = l;
        this.streamBlockSize = n;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.readIntoBuffer();
            }
            catch (SQLException sQLException) {
                throw JavaSystem.toIOException(sQLException);
            }
        }
        int n = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return n;
    }

    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l > this.availableLength) {
            l = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l;
        return l;
    }

    public int available() throws IOException {
        this.checkClosed();
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.blob.isClosed()) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() throws SQLException {
        long l = this.availableLength - this.currentPosition;
        if (l <= 0L) {
            // empty if block
        }
        if (l > (long)this.streamBlockSize) {
            l = this.streamBlockSize;
        }
        this.buffer = this.blob.getBytes(this.currentPosition + 1L, (int)l);
        this.bufferOffset = this.currentPosition;
    }
}

