/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformException;

public class JBossStandAloneJtaPlatform
extends AbstractJtaPlatform {
    public static final String JBOSS_TM_CLASS_NAME = "org.wildfly.transaction.client.ContextTransactionManager";
    public static final String JBOSS_UT_CLASS_NAME = "org.wildfly.transaction.client.LocalUserTransaction";

    @Override
    protected TransactionManager locateTransactionManager() {
        try {
            Class jbossTmClass = this.serviceRegistry().getService(ClassLoaderService.class).classForName(JBOSS_TM_CLASS_NAME);
            return (TransactionManager)jbossTmClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain WildFly Transaction Client transaction manager instance", e);
        }
    }

    @Override
    protected UserTransaction locateUserTransaction() {
        try {
            Class jbossUtClass = this.serviceRegistry().getService(ClassLoaderService.class).classForName(JBOSS_UT_CLASS_NAME);
            return (UserTransaction)jbossUtClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new JtaPlatformException("Could not obtain WildFly Transaction Client user transaction instance", e);
        }
    }
}

