/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validator.HibernateValidatorContext;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import org.hibernate.validator.internal.engine.ConfigurationImpl;
import org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import org.hibernate.validator.internal.engine.ServiceLoaderBasedConstraintMappingContributor;
import org.hibernate.validator.internal.engine.ValidatorContextImpl;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.engine.constraintdefinition.ConstraintDefinitionContribution;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import org.hibernate.validator.internal.engine.scripting.DefaultScriptEvaluatorFactory;
import org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.BeanMetaDataManager;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.ProgrammaticMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.XmlMetaDataProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;
import org.hibernate.validator.internal.util.privilegedactions.NewInstance;
import org.hibernate.validator.spi.cfg.ConstraintMappingContributor;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

public class ValidatorFactoryImpl
implements HibernateValidatorFactory {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ExecutableParameterNameProvider parameterNameProvider;
    private final ClockProvider clockProvider;
    private final Duration temporalValidationTolerance;
    private final ScriptEvaluatorFactory scriptEvaluatorFactory;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final Set<DefaultConstraintMapping> constraintMappings;
    private final ConstraintHelper constraintHelper;
    private final TypeResolutionHelper typeResolutionHelper;
    private final ExecutableHelper executableHelper;
    private final boolean failFast;
    private final MethodValidationConfiguration methodValidationConfiguration;
    private final boolean traversableResolverResultCacheEnabled;
    private final XmlMetaDataProvider xmlMetaDataProvider;
    private final ConcurrentMap<BeanMetaDataManagerKey, BeanMetaDataManager> beanMetaDataManagers;
    private final ValueExtractorManager valueExtractorManager;

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        ClassLoader externalClassLoader = ValidatorFactoryImpl.getExternalClassLoader(configurationState);
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.traversableResolver = configurationState.getTraversableResolver();
        this.parameterNameProvider = new ExecutableParameterNameProvider(configurationState.getParameterNameProvider());
        this.clockProvider = configurationState.getClockProvider();
        this.valueExtractorManager = new ValueExtractorManager(configurationState.getValueExtractors());
        this.beanMetaDataManagers = new ConcurrentHashMap<BeanMetaDataManagerKey, BeanMetaDataManager>();
        this.constraintHelper = new ConstraintHelper();
        this.typeResolutionHelper = new TypeResolutionHelper();
        this.executableHelper = new ExecutableHelper(this.typeResolutionHelper);
        boolean tmpFailFast = false;
        boolean tmpTraversableResolverResultCacheEnabled = true;
        boolean tmpAllowOverridingMethodAlterParameterConstraint = false;
        boolean tmpAllowMultipleCascadedValidationOnReturnValues = false;
        boolean tmpAllowParallelMethodsDefineParameterConstraints = false;
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateSpecificConfig = (ConfigurationImpl)configurationState;
            tmpFailFast = hibernateSpecificConfig.getFailFast();
            tmpAllowOverridingMethodAlterParameterConstraint = hibernateSpecificConfig.getMethodValidationConfiguration().isAllowOverridingMethodAlterParameterConstraint();
            tmpAllowMultipleCascadedValidationOnReturnValues = hibernateSpecificConfig.getMethodValidationConfiguration().isAllowMultipleCascadedValidationOnReturnValues();
            tmpAllowParallelMethodsDefineParameterConstraints = hibernateSpecificConfig.getMethodValidationConfiguration().isAllowParallelMethodsDefineParameterConstraints();
            tmpTraversableResolverResultCacheEnabled = hibernateSpecificConfig.isTraversableResolverResultCacheEnabled();
        }
        this.xmlMetaDataProvider = configurationState.getMappingStreams().isEmpty() ? null : new XmlMetaDataProvider(this.constraintHelper, this.typeResolutionHelper, this.valueExtractorManager, configurationState.getMappingStreams(), externalClassLoader);
        this.constraintMappings = Collections.unmodifiableSet(ValidatorFactoryImpl.getConstraintMappings(this.typeResolutionHelper, configurationState, externalClassLoader));
        ValidatorFactoryImpl.registerCustomConstraintValidators(this.constraintMappings, this.constraintHelper);
        Map properties = configurationState.getProperties();
        this.failFast = tmpFailFast = this.checkPropertiesForFailFast(properties, tmpFailFast);
        MethodValidationConfiguration.Builder methodValidationConfigurationBuilder = new MethodValidationConfiguration.Builder();
        tmpAllowOverridingMethodAlterParameterConstraint = this.checkPropertiesForBoolean(properties, "hibernate.validator.allow_parameter_constraint_override", tmpAllowOverridingMethodAlterParameterConstraint);
        methodValidationConfigurationBuilder.allowOverridingMethodAlterParameterConstraint(tmpAllowOverridingMethodAlterParameterConstraint);
        tmpAllowMultipleCascadedValidationOnReturnValues = this.checkPropertiesForBoolean(properties, "hibernate.validator.allow_multiple_cascaded_validation_on_result", tmpAllowMultipleCascadedValidationOnReturnValues);
        methodValidationConfigurationBuilder.allowMultipleCascadedValidationOnReturnValues(tmpAllowMultipleCascadedValidationOnReturnValues);
        tmpAllowParallelMethodsDefineParameterConstraints = this.checkPropertiesForBoolean(properties, "hibernate.validator.allow_parallel_method_parameter_constraint", tmpAllowParallelMethodsDefineParameterConstraints);
        methodValidationConfigurationBuilder.allowParallelMethodsDefineParameterConstraints(tmpAllowParallelMethodsDefineParameterConstraints);
        this.methodValidationConfiguration = methodValidationConfigurationBuilder.build();
        this.traversableResolverResultCacheEnabled = tmpTraversableResolverResultCacheEnabled = this.checkPropertiesForBoolean(properties, "hibernate.validator.enable_traversable_resolver_result_cache", tmpTraversableResolverResultCacheEnabled);
        this.constraintValidatorManager = new ConstraintValidatorManager(configurationState.getConstraintValidatorFactory());
        this.scriptEvaluatorFactory = ValidatorFactoryImpl.getScriptEvaluatorFactory(configurationState, properties, externalClassLoader);
        this.temporalValidationTolerance = this.getTemporalValidationTolerance(configurationState, properties);
        if (LOG.isDebugEnabled()) {
            ValidatorFactoryImpl.logValidatorFactoryScopedConfiguration(configurationState, this.scriptEvaluatorFactory.getClass());
        }
    }

    private static ClassLoader getExternalClassLoader(ConfigurationState configurationState) {
        return configurationState instanceof ConfigurationImpl ? ((ConfigurationImpl)configurationState).getExternalClassLoader() : null;
    }

    private static Set<DefaultConstraintMapping> getConstraintMappings(TypeResolutionHelper typeResolutionHelper, ConfigurationState configurationState, ClassLoader externalClassLoader) {
        HashSet<DefaultConstraintMapping> constraintMappings = CollectionHelper.newHashSet();
        if (configurationState instanceof ConfigurationImpl) {
            ConfigurationImpl hibernateConfiguration = (ConfigurationImpl)configurationState;
            constraintMappings.addAll(hibernateConfiguration.getProgrammaticMappings());
            ServiceLoaderBasedConstraintMappingContributor serviceLoaderBasedContributor = new ServiceLoaderBasedConstraintMappingContributor(typeResolutionHelper, externalClassLoader != null ? externalClassLoader : ValidatorFactoryImpl.run(GetClassLoader.fromContext()));
            DefaultConstraintMappingBuilder builder = new DefaultConstraintMappingBuilder(constraintMappings);
            serviceLoaderBasedContributor.createConstraintMappings(builder);
        }
        List<ConstraintMappingContributor> contributors = ValidatorFactoryImpl.getPropertyConfiguredConstraintMappingContributors(configurationState.getProperties(), externalClassLoader);
        for (ConstraintMappingContributor contributor : contributors) {
            DefaultConstraintMappingBuilder builder = new DefaultConstraintMappingBuilder(constraintMappings);
            contributor.createConstraintMappings(builder);
        }
        return constraintMappings;
    }

    public Validator getValidator() {
        return this.createValidator(this.constraintValidatorManager.getDefaultConstraintValidatorFactory(), this.messageInterpolator, this.traversableResolver, this.parameterNameProvider, this.clockProvider, this.scriptEvaluatorFactory, this.failFast, this.temporalValidationTolerance, this.valueExtractorManager, this.methodValidationConfiguration, this.traversableResolverResultCacheEnabled);
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorManager.getDefaultConstraintValidatorFactory();
    }

    public ParameterNameProvider getParameterNameProvider() {
        return this.parameterNameProvider.getDelegate();
    }

    public ExecutableParameterNameProvider getExecutableParameterNameProvider() {
        return this.parameterNameProvider;
    }

    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    @Override
    public ScriptEvaluatorFactory getScriptEvaluatorFactory() {
        return this.scriptEvaluatorFactory;
    }

    @Override
    public Duration getTemporalValidationTolerance() {
        return this.temporalValidationTolerance;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    MethodValidationConfiguration getMethodValidationConfiguration() {
        return this.methodValidationConfiguration;
    }

    public boolean isTraversableResolverResultCacheEnabled() {
        return this.traversableResolverResultCacheEnabled;
    }

    ValueExtractorManager getValueExtractorManager() {
        return this.valueExtractorManager;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(HibernateValidatorFactory.class)) {
            return type.cast(this);
        }
        throw LOG.getTypeNotSupportedForUnwrappingException(type);
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new ValidatorContextImpl(this);
    }

    public void close() {
        this.constraintValidatorManager.clear();
        this.constraintHelper.clear();
        for (BeanMetaDataManager beanMetaDataManager : this.beanMetaDataManagers.values()) {
            beanMetaDataManager.clear();
        }
        this.scriptEvaluatorFactory.clear();
    }

    Validator createValidator(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ExecutableParameterNameProvider parameterNameProvider, ClockProvider clockProvider, ScriptEvaluatorFactory scriptEvaluatorFactory, boolean failFast, Duration temporalValidationTolerance, ValueExtractorManager valueExtractorManager, MethodValidationConfiguration methodValidationConfiguration, boolean traversableResolverResultCacheEnabled) {
        ValidationOrderGenerator validationOrderGenerator = new ValidationOrderGenerator();
        BeanMetaDataManager beanMetaDataManager = this.beanMetaDataManagers.computeIfAbsent(new BeanMetaDataManagerKey(parameterNameProvider, valueExtractorManager, methodValidationConfiguration), key -> new BeanMetaDataManager(this.constraintHelper, this.executableHelper, this.typeResolutionHelper, parameterNameProvider, valueExtractorManager, validationOrderGenerator, this.buildDataProviders(), methodValidationConfiguration));
        return new ValidatorImpl(constraintValidatorFactory, messageInterpolator, traversableResolver, beanMetaDataManager, parameterNameProvider, clockProvider, scriptEvaluatorFactory, valueExtractorManager, this.constraintValidatorManager, validationOrderGenerator, failFast, traversableResolverResultCacheEnabled, temporalValidationTolerance);
    }

    private List<MetaDataProvider> buildDataProviders() {
        ArrayList<MetaDataProvider> metaDataProviders = CollectionHelper.newArrayList();
        if (this.xmlMetaDataProvider != null) {
            metaDataProviders.add(this.xmlMetaDataProvider);
        }
        if (!this.constraintMappings.isEmpty()) {
            metaDataProviders.add(new ProgrammaticMetaDataProvider(this.constraintHelper, this.typeResolutionHelper, this.valueExtractorManager, this.constraintMappings));
        }
        return metaDataProviders;
    }

    private boolean checkPropertiesForFailFast(Map<String, String> properties, boolean programmaticValue) {
        boolean value = programmaticValue;
        String propertyStringValue = properties.get("hibernate.validator.fail_fast");
        if (propertyStringValue != null) {
            boolean configurationValue = Boolean.valueOf(propertyStringValue);
            if (programmaticValue && !configurationValue) {
                throw LOG.getInconsistentFailFastConfigurationException();
            }
            value = configurationValue;
        }
        return value;
    }

    private boolean checkPropertiesForBoolean(Map<String, String> properties, String propertyKey, boolean programmaticValue) {
        boolean value = programmaticValue;
        String propertyStringValue = properties.get(propertyKey);
        if (propertyStringValue != null) {
            value = Boolean.valueOf(propertyStringValue);
        }
        return value;
    }

    private static List<ConstraintMappingContributor> getPropertyConfiguredConstraintMappingContributors(Map<String, String> properties, ClassLoader externalClassLoader) {
        String propertyValue = properties.get("hibernate.validator.constraint_mapping_contributors");
        if (StringHelper.isNullOrEmptyString(propertyValue)) {
            return Collections.emptyList();
        }
        String[] contributorNames = propertyValue.toString().split(",");
        ArrayList<ConstraintMappingContributor> contributors = CollectionHelper.newArrayList(contributorNames.length);
        for (String contributorName : contributorNames) {
            Class contributorType = (Class)ValidatorFactoryImpl.run(LoadClass.action(contributorName, externalClassLoader));
            contributors.add((ConstraintMappingContributor)ValidatorFactoryImpl.run(NewInstance.action(contributorType, "constraint mapping contributor class")));
        }
        return contributors;
    }

    private static ScriptEvaluatorFactory getScriptEvaluatorFactory(ConfigurationState configurationState, Map<String, String> properties, ClassLoader externalClassLoader) {
        ConfigurationImpl hibernateSpecificConfig;
        if (configurationState instanceof ConfigurationImpl && (hibernateSpecificConfig = (ConfigurationImpl)configurationState).getScriptEvaluatorFactory() != null) {
            LOG.usingScriptEvaluatorFactory(hibernateSpecificConfig.getScriptEvaluatorFactory().getClass());
            return hibernateSpecificConfig.getScriptEvaluatorFactory();
        }
        String scriptEvaluatorFactoryFqcn = properties.get("hibernate.validator.script_evaluator_factory");
        if (scriptEvaluatorFactoryFqcn != null) {
            try {
                Class clazz = (Class)ValidatorFactoryImpl.run(LoadClass.action(scriptEvaluatorFactoryFqcn, externalClassLoader));
                ScriptEvaluatorFactory scriptEvaluatorFactory = (ScriptEvaluatorFactory)ValidatorFactoryImpl.run(NewInstance.action(clazz, "script evaluator factory class"));
                LOG.usingScriptEvaluatorFactory(clazz);
                return scriptEvaluatorFactory;
            }
            catch (Exception e) {
                throw LOG.getUnableToInstantiateScriptEvaluatorFactoryClassException(scriptEvaluatorFactoryFqcn, e);
            }
        }
        return new DefaultScriptEvaluatorFactory(externalClassLoader);
    }

    private Duration getTemporalValidationTolerance(ConfigurationState configurationState, Map<String, String> properties) {
        ConfigurationImpl hibernateSpecificConfig;
        if (configurationState instanceof ConfigurationImpl && (hibernateSpecificConfig = (ConfigurationImpl)configurationState).getTemporalValidationTolerance() != null) {
            LOG.logTemporalValidationTolerance(hibernateSpecificConfig.getTemporalValidationTolerance());
            return hibernateSpecificConfig.getTemporalValidationTolerance();
        }
        String temporalValidationToleranceProperty = properties.get("hibernate.validator.temporal_validation_tolerance");
        if (temporalValidationToleranceProperty != null) {
            try {
                Duration tolerance = Duration.ofMillis(Long.parseLong(temporalValidationToleranceProperty)).abs();
                LOG.logTemporalValidationTolerance(tolerance);
                return tolerance;
            }
            catch (Exception e) {
                throw LOG.getUnableToParseTemporalValidationToleranceException(temporalValidationToleranceProperty, e);
            }
        }
        LOG.logTemporalValidationTolerance(Duration.ZERO);
        return Duration.ZERO;
    }

    private static void registerCustomConstraintValidators(Set<DefaultConstraintMapping> constraintMappings, ConstraintHelper constraintHelper) {
        HashSet<Class<?>> definedConstraints = CollectionHelper.newHashSet();
        for (DefaultConstraintMapping constraintMapping : constraintMappings) {
            for (ConstraintDefinitionContribution<?> contribution : constraintMapping.getConstraintDefinitionContributions()) {
                ValidatorFactoryImpl.processConstraintDefinitionContribution(contribution, constraintHelper, definedConstraints);
            }
        }
    }

    private static <A extends Annotation> void processConstraintDefinitionContribution(ConstraintDefinitionContribution<A> constraintDefinitionContribution, ConstraintHelper constraintHelper, Set<Class<?>> definedConstraints) {
        Class<A> constraintType = constraintDefinitionContribution.getConstraintType();
        if (definedConstraints.contains(constraintType)) {
            throw LOG.getConstraintHasAlreadyBeenConfiguredViaProgrammaticApiException(constraintType);
        }
        definedConstraints.add(constraintType);
        constraintHelper.putValidatorDescriptors(constraintType, constraintDefinitionContribution.getValidatorDescriptors(), constraintDefinitionContribution.includeExisting());
    }

    private static void logValidatorFactoryScopedConfiguration(ConfigurationState configurationState, Class<? extends ScriptEvaluatorFactory> scriptEvaluatorFactoryClass) {
        LOG.logValidatorFactoryScopedConfiguration(configurationState.getMessageInterpolator().getClass(), "message interpolator");
        LOG.logValidatorFactoryScopedConfiguration(configurationState.getTraversableResolver().getClass(), "traversable resolver");
        LOG.logValidatorFactoryScopedConfiguration(configurationState.getParameterNameProvider().getClass(), "parameter name provider");
        LOG.logValidatorFactoryScopedConfiguration(configurationState.getClockProvider().getClass(), "clock provider");
        LOG.logValidatorFactoryScopedConfiguration(scriptEvaluatorFactoryClass, "script evaluator factory");
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private static class BeanMetaDataManagerKey {
        private final ExecutableParameterNameProvider parameterNameProvider;
        private final ValueExtractorManager valueExtractorManager;
        private final MethodValidationConfiguration methodValidationConfiguration;
        private final int hashCode;

        public BeanMetaDataManagerKey(ExecutableParameterNameProvider parameterNameProvider, ValueExtractorManager valueExtractorManager, MethodValidationConfiguration methodValidationConfiguration) {
            this.parameterNameProvider = parameterNameProvider;
            this.valueExtractorManager = valueExtractorManager;
            this.methodValidationConfiguration = methodValidationConfiguration;
            this.hashCode = BeanMetaDataManagerKey.buildHashCode(parameterNameProvider, valueExtractorManager, methodValidationConfiguration);
        }

        private static int buildHashCode(ExecutableParameterNameProvider parameterNameProvider, ValueExtractorManager valueExtractorManager, MethodValidationConfiguration methodValidationConfiguration) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (methodValidationConfiguration == null ? 0 : methodValidationConfiguration.hashCode());
            result = 31 * result + (parameterNameProvider == null ? 0 : parameterNameProvider.hashCode());
            result = 31 * result + (valueExtractorManager == null ? 0 : valueExtractorManager.hashCode());
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanMetaDataManagerKey other = (BeanMetaDataManagerKey)obj;
            return this.methodValidationConfiguration.equals(other.methodValidationConfiguration) && this.parameterNameProvider.equals(other.parameterNameProvider) && this.valueExtractorManager.equals(other.valueExtractorManager);
        }

        public String toString() {
            return "BeanMetaDataManagerKey [parameterNameProvider=" + this.parameterNameProvider + ", valueExtractorManager=" + this.valueExtractorManager + ", methodValidationConfiguration=" + this.methodValidationConfiguration + "]";
        }
    }

    private static class DefaultConstraintMappingBuilder
    implements ConstraintMappingContributor.ConstraintMappingBuilder {
        private final Set<DefaultConstraintMapping> mappings;

        public DefaultConstraintMappingBuilder(Set<DefaultConstraintMapping> mappings) {
            this.mappings = mappings;
        }

        @Override
        public ConstraintMapping addConstraintMapping() {
            DefaultConstraintMapping mapping = new DefaultConstraintMapping();
            this.mappings.add(mapping);
            return mapping;
        }
    }
}

