/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.framework;

import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;
import org.objectweb.jtests.jms.framework.JMSTestCase;

public abstract class PTPTestCase
extends JMSTestCase {
    protected Context ctx;
    private static final String QCF_NAME = "testQCF";
    private static final String QUEUE_NAME = "testJoramQueue";
    protected Queue senderQueue;
    protected QueueSender sender;
    protected QueueConnectionFactory senderQCF;
    protected QueueConnection senderConnection;
    protected QueueSession senderSession;
    protected Queue receiverQueue;
    protected QueueReceiver receiver;
    protected QueueConnectionFactory receiverQCF;
    protected QueueConnection receiverConnection;
    protected QueueSession receiverSession;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.admin.createQueueConnectionFactory(QCF_NAME);
            this.admin.createQueue(QUEUE_NAME);
            this.ctx = this.admin.createContext();
            this.senderQCF = (QueueConnectionFactory)this.ctx.lookup(QCF_NAME);
            this.senderQueue = (Queue)this.ctx.lookup(QUEUE_NAME);
            this.senderConnection = this.senderQCF.createQueueConnection();
            this.senderSession = this.senderConnection.createQueueSession(false, 1);
            this.sender = this.senderSession.createSender(this.senderQueue);
            this.receiverQCF = (QueueConnectionFactory)this.ctx.lookup(QCF_NAME);
            this.receiverQueue = (Queue)this.ctx.lookup(QUEUE_NAME);
            this.receiverConnection = this.receiverQCF.createQueueConnection();
            this.receiverSession = this.receiverConnection.createQueueSession(false, 1);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            this.senderConnection.start();
            this.receiverConnection.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.senderConnection.close();
            this.receiverConnection.close();
            this.admin.deleteQueueConnectionFactory(QCF_NAME);
            this.admin.deleteQueue(QUEUE_NAME);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        finally {
            this.senderQueue = null;
            this.sender = null;
            this.senderQCF = null;
            this.senderSession = null;
            this.senderConnection = null;
            this.receiverQueue = null;
            this.receiver = null;
            this.receiverQCF = null;
            this.receiverSession = null;
            this.receiverConnection = null;
        }
        super.tearDown();
    }

    public PTPTestCase(String name) {
        super(name);
    }
}

