/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.framework;

import java.io.IOException;
import java.util.Properties;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.objectweb.jtests.jms.admin.Admin;
import org.objectweb.jtests.jms.admin.AdminFactory;

public abstract class JMSTestCase
extends TestCase {
    public static final String PROP_FILE_NAME = "provider.properties";
    public static boolean startServer = true;
    protected Admin admin;

    public void fail(Exception e) {
        if (e instanceof JMSException) {
            JMSException exception = (JMSException)((Object)e);
            String message = e.toString();
            Exception linkedException = exception.getLinkedException();
            if (linkedException != null) {
                message = message + " [linked exception: " + linkedException + "]";
            }
            TestCase.fail((String)message);
        } else {
            TestCase.fail((String)e.getMessage());
        }
    }

    public JMSTestCase(String name) {
        super(name);
    }

    protected Properties getProviderProperties() throws IOException {
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(System.getProperty("joram.jms.test.file", PROP_FILE_NAME)));
        return props;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Properties props = this.getProviderProperties();
        this.admin = AdminFactory.getAdmin(props);
        if (startServer) {
            this.admin.startServer();
        }
        this.admin.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.admin.stop();
            if (startServer) {
                this.admin.stopServer();
            }
        }
        finally {
            super.tearDown();
        }
    }
}

