/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.topic;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PubSubTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class TemporaryTopicTest
extends PubSubTestCase {
    private TemporaryTopic tempTopic;
    private TopicSubscriber tempSubscriber;

    public void testTemporaryTopic() {
        try {
            this.publisherConnection.stop();
            this.subscriberConnection.stop();
            this.tempTopic = this.subscriberSession.createTemporaryTopic();
            this.publisher = this.publisherSession.createPublisher((Topic)this.tempTopic);
            this.tempSubscriber = this.subscriberSession.createSubscriber((Topic)this.tempTopic);
            this.subscriberConnection.start();
            this.publisherConnection.start();
            TextMessage message = this.publisherSession.createTextMessage();
            message.setText("testTemporaryTopic");
            this.publisher.publish((Message)message);
            Message m = this.tempSubscriber.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((String)"testTemporaryTopic", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(TemporaryTopicTest.class);
    }

    public TemporaryTopicTest(String name) {
        super(name);
    }
}

