/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.UnifiedTestCase;

public class UnifiedSessionTest
extends UnifiedTestCase {
    protected QueueConnection queueConnection;
    protected QueueSession queueSession;
    protected TopicConnection topicConnection;
    protected TopicSession topicSession;

    public void testCreateDurableConnectionConsumerOnQueueConnection() {
        try {
            this.queueConnection.createDurableConnectionConsumer(this.topic, "subscriptionName", "", (ServerSessionPool)null, 1);
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateDurableSubscriberOnQueueSession() {
        try {
            this.queueSession.createDurableSubscriber(this.topic, "subscriptionName");
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateTemporaryTopicOnQueueSession() {
        try {
            this.queueSession.createTemporaryTopic();
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateTopicOnQueueSession() {
        try {
            this.queueSession.createTopic("topic_name");
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testUnsubscribeOnQueueSession() {
        try {
            this.queueSession.unsubscribe("subscriptionName");
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateBrowserOnTopicSession() {
        try {
            this.topicSession.createBrowser(this.queue);
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateQueueOnTopicSession() {
        try {
            this.topicSession.createQueue("queue_name");
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateTemporaryQueueOnTopicSession() {
        try {
            this.topicSession.createTemporaryQueue();
            Assert.fail((String)"Should throw a javax.jms.IllegalStateException");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.queueConnection = this.queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.queueConnection.start();
            this.topicConnection.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tearDown() throws Exception {
        try {
            try {
                this.queueConnection.close();
                this.topicConnection.close();
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.queueConnection = null;
                this.queueSession = null;
                this.topicConnection = null;
                this.topicSession = null;
                super.tearDown();
                return;
            }
            Object var3_1 = null;
            this.queueConnection = null;
            this.queueSession = null;
            this.topicConnection = null;
            this.topicSession = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.queueConnection = null;
            this.queueSession = null;
            this.topicConnection = null;
            this.topicSession = null;
            super.tearDown();
            throw throwable;
        }
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(UnifiedSessionTest.class);
    }

    public UnifiedSessionTest(String name) {
        super(name);
    }
}

