/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class QueueSessionTest
extends PTPTestCase {
    public void testRollbackRececeivedMessage() {
        try {
            this.senderConnection.stop();
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            Assert.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
            this.sender = this.senderSession.createSender(this.senderQueue);
            this.senderConnection.start();
            this.receiverConnection.stop();
            this.receiverSession = this.receiverConnection.createQueueSession(true, 0);
            Assert.assertEquals((boolean)true, (boolean)this.receiverSession.getTransacted());
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            this.receiverConnection.start();
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testRollbackRececeivedMessage");
            this.sender.send((Message)message);
            this.senderSession.commit();
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((String)"testRollbackRececeivedMessage", (String)msg.getText());
            Assert.assertEquals((boolean)false, (boolean)msg.getJMSRedelivered());
            this.receiverSession.rollback();
            m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            msg = (TextMessage)m;
            Assert.assertEquals((String)"testRollbackRececeivedMessage", (String)msg.getText());
            Assert.assertEquals((boolean)true, (boolean)msg.getJMSRedelivered());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testCreateBrowser_2() {
        try {
            this.senderSession.createBrowser(this.senderQueue, "definitely not a message selector!");
            Assert.fail((String)"Should throw a javax.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.InvalidSelectorException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateBrowser_1() {
        try {
            this.senderSession.createBrowser((Queue)null);
            Assert.fail((String)"Should throw a javax.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.InvalidDestinationException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateReceiver_2() {
        try {
            this.receiver = this.senderSession.createReceiver(this.senderQueue, "definitely not a message selector!");
            Assert.fail((String)"Should throw a javax.jms.InvalidSelectorException.\n");
        }
        catch (InvalidSelectorException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.InvalidSelectorException, not a " + (Object)((Object)e)));
        }
    }

    public void testCreateReceiver_1() {
        try {
            this.receiver = this.senderSession.createReceiver((Queue)null);
            Assert.fail((String)"Should throw a javax.jms.InvalidDestinationException.\n");
        }
        catch (InvalidDestinationException e) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a javax.jms.InvalidDestinationException, not a " + (Object)((Object)e)));
        }
    }

    public static Test suite() {
        return new TestSuite(QueueSessionTest.class);
    }

    public QueueSessionTest(String name) {
        super(name);
    }
}

