/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message.properties;

import java.util.Enumeration;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class JMSXPropertyTest
extends PTPTestCase {
    public void testSupportsJMSXGroupID() {
        try {
            boolean found = false;
            ConnectionMetaData metaData = this.senderConnection.getMetaData();
            Enumeration enumeration = metaData.getJMSXPropertyNames();
            while (enumeration.hasMoreElements()) {
                String jmsxPropertyName = (String)enumeration.nextElement();
                if (!jmsxPropertyName.equals("JMSXGroupID")) continue;
                found = true;
            }
            Assert.assertTrue((String)"JMSXGroupID property is not supported", (boolean)found);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSXGroupID_1() {
        try {
            String groupID = "testSupportsJMSXGroupID_1:group";
            TextMessage message = this.senderSession.createTextMessage();
            message.setStringProperty("JMSXGroupID", groupID);
            message.setText("testSupportsJMSXGroupID_1");
            this.sender.send((Message)message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((String)groupID, (String)msg.getStringProperty("JMSXGroupID"));
            Assert.assertEquals((String)"testSupportsJMSXGroupID_1", (String)msg.getText());
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testJMSXDeliveryCount() throws Exception {
        if (!this.supportsJMSXDeliveryCount()) {
            return;
        }
        try {
            this.senderConnection.stop();
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            Assert.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
            this.sender = this.senderSession.createSender(this.senderQueue);
            this.senderConnection.start();
            this.receiverConnection.stop();
            this.receiverSession = this.receiverConnection.createQueueSession(true, 0);
            Assert.assertEquals((boolean)true, (boolean)this.receiverSession.getTransacted());
            if (this.receiver != null) {
                this.receiver.close();
            }
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            this.receiverConnection.start();
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testJMSXDeliveryCount");
            this.sender.send((Message)message);
            this.senderSession.commit();
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage msg = (TextMessage)m;
            Assert.assertEquals((String)"testJMSXDeliveryCount", (String)msg.getText());
            Assert.assertEquals((boolean)false, (boolean)msg.getJMSRedelivered());
            int jmsxDeliveryCount = msg.getIntProperty("JMSXDeliveryCount");
            Assert.assertEquals((int)1, (int)jmsxDeliveryCount);
            this.receiverSession.rollback();
            m = this.receiver.receive(TestConfig.TIMEOUT);
            Assert.assertTrue((m != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(m instanceof TextMessage));
            msg = (TextMessage)m;
            Assert.assertEquals((String)"testJMSXDeliveryCount", (String)msg.getText());
            Assert.assertEquals((boolean)true, (boolean)msg.getJMSRedelivered());
            jmsxDeliveryCount = msg.getIntProperty("JMSXDeliveryCount");
            Assert.assertEquals((int)2, (int)jmsxDeliveryCount);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    private boolean supportsJMSXDeliveryCount() throws Exception {
        ConnectionMetaData metaData = this.senderConnection.getMetaData();
        Enumeration enumeration = metaData.getJMSXPropertyNames();
        while (enumeration.hasMoreElements()) {
            String jmsxPropertyName = (String)enumeration.nextElement();
            if (!jmsxPropertyName.equals("JMSXDeliveryCount")) continue;
            return true;
        }
        return false;
    }

    public static Test suite() {
        return new TestSuite(JMSXPropertyTest.class);
    }

    public JMSXPropertyTest(String name) {
        super(name);
    }
}

