/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.transaction;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.flowable.engine.common.impl.cfg.BaseTransactionContext;
import org.flowable.engine.common.impl.transaction.TransactionContextHolder;

public class TransactionContextAwareTransactionFactory<T>
implements TransactionFactory {
    protected Class<T> transactionContextClass;
    protected ManagedTransactionFactory managedTransactionFactory;
    protected JdbcTransactionFactory jdbcTransactionFactory;

    public TransactionContextAwareTransactionFactory(Class<T> transactionContextClass) {
        this.transactionContextClass = transactionContextClass;
        this.jdbcTransactionFactory = new JdbcTransactionFactory();
        this.managedTransactionFactory = new ManagedTransactionFactory();
        Properties properties = new Properties();
        properties.put("closeConnection", "false");
        this.managedTransactionFactory.setProperties(properties);
    }

    public void setProperties(Properties props) {
        if (this.isNonIdmTransactionContextActive()) {
            this.managedTransactionFactory.setProperties(props);
        } else {
            this.jdbcTransactionFactory.setProperties(props);
        }
    }

    public Transaction newTransaction(Connection conn) {
        if (this.isNonIdmTransactionContextActive()) {
            return this.managedTransactionFactory.newTransaction(conn);
        }
        return this.jdbcTransactionFactory.newTransaction(conn);
    }

    public Transaction newTransaction(DataSource dataSource, TransactionIsolationLevel level, boolean autoCommit) {
        if (this.isNonIdmTransactionContextActive()) {
            return this.managedTransactionFactory.newTransaction(dataSource, level, autoCommit);
        }
        return this.jdbcTransactionFactory.newTransaction(dataSource, level, autoCommit);
    }

    protected boolean isNonIdmTransactionContextActive() {
        BaseTransactionContext transactionContext = TransactionContextHolder.getTransactionContext();
        if (transactionContext != null) {
            return !this.transactionContextClass.isInstance(transactionContext);
        }
        return false;
    }
}

