/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineRequest;
import org.elasticsearch.action.ingest.GetPipelineResponse;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.elasticsearch.action.ingest.WritePipelineResponse;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public final class IngestClient {
    private final RestHighLevelClient restHighLevelClient;

    IngestClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public WritePipelineResponse putPipeline(PutPipelineRequest request, RequestOptions options) throws IOException {
        return (WritePipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::putPipeline, options, WritePipelineResponse::fromXContent, Collections.emptySet());
    }

    public void putPipelineAsync(PutPipelineRequest request, RequestOptions options, ActionListener<WritePipelineResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::putPipeline, options, WritePipelineResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPipelineResponse getPipeline(GetPipelineRequest request, RequestOptions options) throws IOException {
        return (GetPipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, Collections.singleton(404));
    }

    public void getPipelineAsync(GetPipelineRequest request, RequestOptions options, ActionListener<GetPipelineResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::getPipeline, options, GetPipelineResponse::fromXContent, listener, Collections.singleton(404));
    }

    public WritePipelineResponse deletePipeline(DeletePipelineRequest request, RequestOptions options) throws IOException {
        return (WritePipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::deletePipeline, options, WritePipelineResponse::fromXContent, Collections.emptySet());
    }

    public void deletePipelineAsync(DeletePipelineRequest request, RequestOptions options, ActionListener<WritePipelineResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::deletePipeline, options, WritePipelineResponse::fromXContent, listener, Collections.emptySet());
    }

    public SimulatePipelineResponse simulate(SimulatePipelineRequest request, RequestOptions options) throws IOException {
        return (SimulatePipelineResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, Collections.emptySet());
    }

    public void simulateAsync(SimulatePipelineRequest request, RequestOptions options, ActionListener<SimulatePipelineResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::simulatePipeline, options, SimulatePipelineResponse::fromXContent, listener, Collections.emptySet());
    }
}

