/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.buildtimestamp.jgit;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.tycho.buildversion.BuildTimestampProvider;
import org.eclipse.tycho.extras.buildtimestamp.jgit.PathFilter;

@Component(role=BuildTimestampProvider.class, hint="jgit")
public class JGitBuildTimestampProvider
implements BuildTimestampProvider {
    @Requirement(hint="default")
    private BuildTimestampProvider defaultTimestampProvider;
    @Requirement
    private Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Date getTimestamp(MavenSession session, MavenProject project, MojoExecution execution) throws MojoExecutionException {
        FileRepositoryBuilder builder = (FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(project.getBasedir())).setMustExist(true);
        if (builder.getGitDir() == null) {
            throw new MojoExecutionException("No git repository found searching upwards from " + project.getBasedir());
        }
        try {
            Repository repository = builder.build();
            try {
                Date date;
                String relPath = this.getRelPath(repository, project);
                TreeFilter pathFilter = JGitBuildTimestampProvider.createPathFilter(relPath, execution);
                ObjectId headId = repository.resolve("HEAD");
                DirtyBehavior dirtyBehaviour = DirtyBehavior.getDirtyWorkingTreeBehaviour(execution);
                if (dirtyBehaviour != DirtyBehavior.IGNORE) {
                    IndexDiff diff = new IndexDiff(repository, headId, (WorkingTreeIterator)new FileTreeIterator(repository));
                    if (pathFilter != null) {
                        diff.setFilter(pathFilter);
                    }
                    diff.diff();
                    Status status = new Status(diff);
                    if (!status.isClean()) {
                        String message = "Working tree is dirty.\ngit status " + (relPath != null ? relPath : "") + ":\n" + JGitBuildTimestampProvider.toGitStatusStyleOutput(diff);
                        if (dirtyBehaviour == DirtyBehavior.WARNING) {
                            this.logger.warn(message);
                            this.logger.warn("Fallback to default timestamp provider");
                            Date date2 = this.defaultTimestampProvider.getTimestamp(session, project, execution);
                            return date2;
                        }
                        throw new MojoExecutionException(message + "\n" + "You are trying to use tycho-buildtimestamp-jgit on a directory that has uncommitted changes (see details above)." + "\nEither commit all changes/add files to .gitignore, or enable fallback to default timestamp provider by configuring " + "\njgit.dirtyWorkingTree=warning for tycho-packaging-plugin");
                    }
                }
                RevWalk walk = new RevWalk(repository);
                try {
                    if (pathFilter != null) {
                        walk.setTreeFilter(AndTreeFilter.create((TreeFilter)pathFilter, (TreeFilter)TreeFilter.ANY_DIFF));
                    }
                    walk.markStart(walk.parseCommit((AnyObjectId)headId));
                    RevCommit commit = walk.next();
                    date = new Date((long)commit.getCommitTime() * 1000L);
                }
                catch (Throwable throwable) {
                    walk.release();
                    throw throwable;
                }
                walk.release();
                return date;
            }
            finally {
                repository.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not determine git commit timestamp", (Exception)e);
        }
    }

    private static TreeFilter createPathFilter(String relPath, MojoExecution execution) throws IOException {
        if (relPath != null && relPath.length() > 0) {
            return new PathFilter(relPath, JGitBuildTimestampProvider.getIgnoreFilter(execution));
        }
        return null;
    }

    private static String getIgnoreFilter(MojoExecution execution) {
        Xpp3Dom pluginConfiguration = (Xpp3Dom)execution.getPlugin().getConfiguration();
        if (pluginConfiguration == null) {
            return null;
        }
        Xpp3Dom ignoreDom = pluginConfiguration.getChild("jgit.ignore");
        if (ignoreDom == null) {
            return null;
        }
        return ignoreDom.getValue();
    }

    private String getRelPath(Repository repository, MavenProject project) throws IOException {
        String workTree = repository.getWorkTree().getCanonicalPath();
        String path = project.getBasedir().getCanonicalPath();
        if (!path.startsWith(workTree)) {
            throw new IOException(project + " is not in git repository working tree " + repository.getWorkTree());
        }
        if ((path = path.substring(workTree.length())).startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    private static String toGitStatusStyleOutput(IndexDiff diff) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ArrayList toBeCommitted = new ArrayList(diff.getAdded());
        toBeCommitted.addAll(diff.getChanged());
        toBeCommitted.addAll(diff.getRemoved());
        if (toBeCommitted.size() > 0) {
            pw.println("Changes to be committed:");
            JGitBuildTimestampProvider.printList(pw, "\tnew file:    ", diff.getAdded());
            JGitBuildTimestampProvider.printList(pw, "\tmodified:    ", diff.getChanged());
            JGitBuildTimestampProvider.printList(pw, "\tdeleted:     ", diff.getRemoved());
        }
        ArrayList notStaged = new ArrayList(diff.getModified());
        notStaged.addAll(diff.getMissing());
        if (notStaged.size() > 0) {
            pw.println();
            pw.println("Changes not staged for commit:");
            JGitBuildTimestampProvider.printList(pw, "\tmodified:    ", diff.getModified());
            JGitBuildTimestampProvider.printList(pw, "\tdeleted:     ", diff.getMissing());
        }
        if (diff.getConflicting().size() > 0) {
            pw.println();
            pw.println("Conflicting files:");
            JGitBuildTimestampProvider.printList(pw, "\tconflict:    ", diff.getConflicting());
        }
        if (diff.getUntracked().size() > 0) {
            pw.println();
            pw.println("Untracked files:");
            JGitBuildTimestampProvider.printList(pw, "\t", diff.getUntracked());
        }
        return sw.toString();
    }

    private static void printList(PrintWriter witer, String prefix, Set<String> files) {
        for (String file : files) {
            witer.println(prefix + file);
        }
    }

    private static enum DirtyBehavior {
        ERROR,
        WARNING,
        IGNORE;


        public static DirtyBehavior getDirtyWorkingTreeBehaviour(MojoExecution execution) {
            DirtyBehavior defaultBehaviour = ERROR;
            Xpp3Dom pluginConfiguration = (Xpp3Dom)execution.getPlugin().getConfiguration();
            if (pluginConfiguration == null) {
                return defaultBehaviour;
            }
            Xpp3Dom dirtyWorkingTreeDom = pluginConfiguration.getChild("jgit.dirtyWorkingTree");
            if (dirtyWorkingTreeDom == null) {
                return defaultBehaviour;
            }
            String value = dirtyWorkingTreeDom.getValue();
            if (value == null) {
                return defaultBehaviour;
            }
            if ("warning".equals(value = value.trim())) {
                return WARNING;
            }
            if ("ignore".equals(value)) {
                return IGNORE;
            }
            return defaultBehaviour;
        }
    }
}

