/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostConstructAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;
    protected LifeCycleCallbackCollection _callbacks;

    public PostConstructAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
        this._callbacks = (LifeCycleCallbackCollection)this._wac.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@PostConstruct annotation not applicable to classes: " + className));
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@PostConstruct annotation not applicable to fields: " + className + "." + fieldName));
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String desc, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        try {
            Type[] args = Type.getArgumentTypes((String)desc);
            if (args.length != 0) {
                Log.warn((String)("Skipping PostConstruct annotation on " + className + "." + methodName + ": has parameters"));
                return;
            }
            if (Type.getReturnType((String)desc) != Type.VOID_TYPE) {
                Log.warn((String)("Skipping PostConstruct annotation on " + className + "." + methodName + ": is not void"));
                return;
            }
            if (exceptions != null && exceptions.length != 0) {
                Log.warn((String)("Skipping PostConstruct annotation on " + className + "." + methodName + ": throws checked exceptions"));
                return;
            }
            if ((access & 8) > 0) {
                Log.warn((String)("Skipping PostConstruct annotation on " + className + "." + methodName + ": is static"));
                return;
            }
            PostConstructCallback callback = new PostConstructCallback();
            callback.setTarget(className, methodName);
            this._callbacks.add((LifeCycleCallback)callback);
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
    }
}

