/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeRequest;
import org.eclipse.jetty.websocket.jsr356.server.JsrHandshakeResponse;
import org.eclipse.jetty.websocket.jsr356.server.PathParamServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.ServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.pathmap.WebSocketPathSpec;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class JsrCreator
implements WebSocketCreator {
    private static final Logger LOG = Log.getLogger(JsrCreator.class);
    private final ServerEndpointMetadata metadata;
    private final ExtensionFactory extensionFactory;

    public JsrCreator(ServerEndpointMetadata metadata, ExtensionFactory extensionFactory) {
        this.metadata = metadata;
        this.extensionFactory = extensionFactory;
    }

    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        List requested;
        JsrHandshakeRequest hsreq = new JsrHandshakeRequest(req);
        JsrHandshakeResponse hsresp = new JsrHandshakeResponse((UpgradeResponse)resp);
        ServerEndpointConfig config = this.metadata.getConfig();
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        configurator.modifyHandshake(config, (HandshakeRequest)hsreq, (HandshakeResponse)hsresp);
        if (!configurator.checkOrigin(req.getOrigin())) {
            try {
                resp.sendForbidden("Origin mismatch");
            }
            catch (IOException e) {
                LOG.debug("Unable to send error response", (Throwable)e);
            }
            return null;
        }
        List supported = config.getSubprotocols();
        String subprotocol = configurator.getNegotiatedSubprotocol(supported, requested = req.getSubProtocols());
        if (subprotocol != null) {
            resp.setAcceptedSubProtocol(subprotocol);
        }
        ArrayList<JsrExtension> installedExts = new ArrayList<JsrExtension>();
        for (String extName : this.extensionFactory.getAvailableExtensions().keySet()) {
            installedExts.add(new JsrExtension(extName));
        }
        ArrayList<JsrExtension> requestedExts = new ArrayList<JsrExtension>();
        for (ExtensionConfig reqCfg : req.getExtensions()) {
            requestedExts.add(new JsrExtension(reqCfg));
        }
        List usedExts = configurator.getNegotiatedExtensions(installedExts, requestedExts);
        ArrayList<ExtensionConfig> configs = new ArrayList<ExtensionConfig>();
        if (usedExts != null) {
            for (Extension used : usedExts) {
                ExtensionConfig ecfg = new ExtensionConfig(used.getName());
                for (Extension.Parameter param : used.getParameters()) {
                    ecfg.setParameter(param.getName(), param.getValue());
                }
                configs.add(ecfg);
            }
        }
        resp.setExtensions(configs);
        try {
            Class endpointClass = config.getEndpointClass();
            Object endpoint = config.getConfigurator().getEndpointInstance(endpointClass);
            PathSpec pathSpec = hsreq.getRequestPathSpec();
            if (pathSpec instanceof WebSocketPathSpec) {
                WebSocketPathSpec wspathSpec = (WebSocketPathSpec)pathSpec;
                String requestPath = req.getRequestPath();
                config = new PathParamServerEndpointConfig(config, wspathSpec, requestPath);
            }
            return new EndpointInstance(endpoint, (EndpointConfig)config, (EndpointMetadata)this.metadata);
        }
        catch (InstantiationException e) {
            LOG.debug("Unable to create websocket: " + config.getEndpointClass().getName(), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return String.format("%s[metadata=%s]", this.getClass().getName(), this.metadata);
    }
}

