/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Expand {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public Untar() {
        super(null);
    }

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    public void setScanForUnicodeExtraFields(boolean b) {
        throw new BuildException("The " + this.getTaskName() + " task doesn't support the encoding" + " attribute", this.getLocation());
    }

    protected void expandFile(FileUtils fileUtils, File srcF, File dir2) {
        FileInputStream fis = null;
        if (!srcF.exists()) {
            throw new BuildException("Unable to untar " + srcF + " as the file does not exist", this.getLocation());
        }
        try {
            fis = new FileInputStream(srcF);
            this.expandStream(srcF.getPath(), fis, dir2);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Error while expanding " + srcF.getPath() + "\n" + ioe.toString(), ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(fis);
                throw throwable;
            }
        }
        FileUtils.close(fis);
    }

    protected void expandResource(Resource srcR, File dir2) {
        if (!srcR.isExists()) {
            throw new BuildException("Unable to untar " + srcR.getName() + " as the it does not exist", this.getLocation());
        }
        InputStream i = null;
        try {
            i = srcR.getInputStream();
            this.expandStream(srcR.getName(), i, dir2);
        }
        catch (IOException ioe) {
            throw new BuildException("Error while expanding " + srcR.getName(), ioe, this.getLocation());
        }
        finally {
            FileUtils.close(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandStream(String name, InputStream stream, File dir2) throws IOException {
        TarInputStream tis = null;
        try {
            tis = new TarInputStream(this.compression.decompress(name, new BufferedInputStream(stream)), this.getEncoding());
            this.log("Expanding: " + name + " into " + dir2, 2);
            TarEntry te = null;
            boolean empty = true;
            FileNameMapper mapper = this.getMapper();
            while ((te = tis.getNextEntry()) != null) {
                empty = false;
                this.extractFile(FileUtils.getFileUtils(), null, dir2, tis, te.getName(), te.getModTime(), te.isDirectory(), mapper);
            }
            if (empty && this.getFailOnEmptyArchive()) {
                throw new BuildException("archive '" + name + "' is empty");
            }
            this.log("expand complete", 3);
        }
        catch (Throwable throwable) {
            FileUtils.close(tis);
            throw throwable;
        }
        FileUtils.close(tis);
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        private static final String NONE = "none";
        private static final String GZIP = "gzip";
        private static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            this.setValue(NONE);
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        public InputStream decompress(String name, InputStream istream) throws IOException, BuildException {
            String v = this.getValue();
            if (GZIP.equals(v)) {
                return new GZIPInputStream(istream);
            }
            if (BZIP2.equals(v)) {
                char[] magic = new char[]{'B', 'Z'};
                for (int i = 0; i < magic.length; ++i) {
                    if (istream.read() == magic[i]) continue;
                    throw new BuildException("Invalid bz2 file." + name);
                }
                return new CBZip2InputStream(istream);
            }
            return istream;
        }
    }
}

