/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.easymock.internal.ArgumentToString;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.matchers.Captures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation
implements Serializable {
    private static final long serialVersionUID = 1604995470419943411L;
    private final Object mock;
    private transient Method method;
    private final Object[] arguments;
    private final Collection<Captures<?>> currentCaptures = new ArrayList(0);

    public Invocation(Object mock, Method method, Object[] args) {
        this.mock = mock;
        this.method = method;
        this.arguments = Invocation.expandVarArgs(method.isVarArgs(), args);
    }

    private static Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        if (!isVarArgs) {
            return args == null ? new Object[]{} : args;
        }
        if (args[args.length - 1] == null) {
            return args;
        }
        Object[] varArgs = Invocation.createObjectArray(args[args.length - 1]);
        int nonVarArgsCount = args.length - 1;
        int varArgsCount = varArgs.length;
        Object[] newArgs = new Object[nonVarArgsCount + varArgsCount];
        System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    private static Object[] createObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        Object[] result = new Object[Array.getLength(array)];
        for (int i = 0; i < Array.getLength(array); ++i) {
            result[i] = Array.get(array, i);
        }
        return result;
    }

    public Object getMock() {
        return this.mock;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Invocation other = (Invocation)o;
        return this.mock.equals(other.mock) && this.method.equals(other.method) && this.equalArguments(other.arguments);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not implemented");
    }

    public String toString() {
        return this.getMockAndMethodName() + "(" + ArgumentToString.argumentsToString(this.arguments) + ")";
    }

    private boolean equalArguments(Object[] arguments) {
        if (this.arguments.length != arguments.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Object myArgument = this.arguments[i];
            Object otherArgument = arguments[i];
            if (!(this.isPrimitiveParameter(i) ? !myArgument.equals(otherArgument) : myArgument != otherArgument)) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimitiveParameter(int parameterPosition) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (this.method.isVarArgs()) {
            parameterPosition = Math.min(parameterPosition, parameterTypes.length - 1);
        }
        return parameterTypes[parameterPosition].isPrimitive();
    }

    public String getMockAndMethodName() {
        String mockName = this.mock.toString();
        String methodName = this.method.getName();
        if (this.toStringIsDefined(this.mock) && Invocation.isJavaIdentifier(mockName)) {
            return mockName + "." + methodName;
        }
        return methodName;
    }

    public void addCapture(Captures<Object> capture, Object value) {
        capture.setPotentialValue(value);
        this.currentCaptures.add(capture);
    }

    public void validateCaptures() {
        for (Captures<?> c : this.currentCaptures) {
            c.validateCapture();
        }
    }

    public void clearCaptures() {
        for (Captures<?> c : this.currentCaptures) {
            c.setPotentialValue(null);
        }
        this.currentCaptures.clear();
    }

    private boolean toStringIsDefined(Object o) {
        try {
            o.getClass().getDeclaredMethod("toString", null).getModifiers();
            return true;
        }
        catch (SecurityException ignored) {
            return false;
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
    }

    public static boolean isJavaIdentifier(String mockName) {
        if (mockName.length() == 0 || mockName.indexOf(32) > -1 || !Character.isJavaIdentifierStart(mockName.charAt(0))) {
            return false;
        }
        for (char c : mockName.substring(1).toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.method = ((MethodSerializationWrapper)stream.readObject()).getMethod();
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(new MethodSerializationWrapper(this.method));
    }
}

