/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.WindowNode;
import org.drools.rule.Behavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BehaviorManager
implements Externalizable {
    public static final Behavior[] NO_BEHAVIORS = new Behavior[0];
    private Behavior[] behaviors;

    public BehaviorManager() {
        this(NO_BEHAVIORS);
    }

    public BehaviorManager(List<Behavior> behaviors) {
        this.behaviors = behaviors.toArray(new Behavior[behaviors.size()]);
    }

    public BehaviorManager(Behavior[] behaviors) {
        this.behaviors = behaviors;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.behaviors = (Behavior[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.behaviors);
    }

    public Object createBehaviorContext() {
        Object[] behaviorCtx = new Object[this.behaviors.length];
        for (int i = 0; i < this.behaviors.length; ++i) {
            behaviorCtx[i] = this.behaviors[i].createContext();
        }
        return behaviorCtx;
    }

    public boolean assertFact(WindowNode.WindowMemory memory, InternalFactHandle factHandle, InternalWorkingMemory workingMemory) {
        boolean result = true;
        for (int i = 0; i < this.behaviors.length; ++i) {
            result = result && this.behaviors[i].assertFact(memory, ((Object[])memory.behaviorContext)[i], factHandle, workingMemory);
        }
        return result;
    }

    public void retractFact(WindowNode.WindowMemory memory, InternalFactHandle factHandle, InternalWorkingMemory workingMemory) {
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].retractFact(memory, ((Object[])memory.behaviorContext)[i], factHandle, workingMemory);
        }
    }

    public Behavior[] getBehaviors() {
        return this.behaviors;
    }
}

