/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.impl.SignatureParser;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringConfigurator
implements Configurator {
    private Map<String, String> creatorTypes;
    private Map<String, String> converterTypes;
    private Map<String, CreatorConfig> creators;
    private Map<String, ConverterConfig> converters;
    private String signatures;

    @Override
    public void configure(Container container) {
        String className;
        String typeName;
        AccessControl accessControl = container.getBean(AccessControl.class);
        AjaxFilterManager ajaxFilterManager = container.getBean(AjaxFilterManager.class);
        ConverterManager converterManager = container.getBean(ConverterManager.class);
        CreatorManager creatorManager = container.getBean(CreatorManager.class);
        if (this.creatorTypes != null) {
            for (Map.Entry<String, String> entry : this.creatorTypes.entrySet()) {
                typeName = entry.getKey();
                className = entry.getValue();
                creatorManager.addCreatorType(typeName, className);
            }
        }
        if (this.converterTypes != null) {
            for (Map.Entry<String, String> entry : this.converterTypes.entrySet()) {
                typeName = entry.getKey();
                className = entry.getValue();
                converterManager.addConverterType(typeName, className);
            }
        }
        if (this.creators != null) {
            try {
                for (Map.Entry<String, Object> entry : this.creators.entrySet()) {
                    String scriptName = entry.getKey();
                    CreatorConfig creatorConfig = (CreatorConfig)entry.getValue();
                    if (creatorConfig.getCreator() != null) {
                        Creator creator = creatorConfig.getCreator();
                        creatorManager.addCreator(scriptName, creator);
                    } else {
                        String creatorName = creatorConfig.getCreatorType();
                        Map<String, String> params = creatorConfig.getParams();
                        creatorManager.addCreator(scriptName, creatorName, params);
                    }
                    for (String exclude : creatorConfig.getExcludes()) {
                        accessControl.addExcludeRule(scriptName, exclude);
                    }
                    for (String include : creatorConfig.getIncludes()) {
                        accessControl.addIncludeRule(scriptName, include);
                    }
                    Properties auth = creatorConfig.getAuth();
                    for (Map.Entry<Object, Object> aentry : auth.entrySet()) {
                        String methodName = (String)aentry.getKey();
                        String role = (String)aentry.getValue();
                        accessControl.addRoleRestriction(scriptName, methodName, role);
                    }
                    List<?> filters = creatorConfig.getFilters();
                    for (Object obj : filters) {
                        if (obj instanceof String) {
                            String filterName = (String)obj;
                            AjaxFilter filter = LocalUtil.classNewInstance(filterName, filterName, AjaxFilter.class);
                            if (filter == null) continue;
                            ajaxFilterManager.addAjaxFilter(filter, scriptName);
                            continue;
                        }
                        if (obj instanceof AjaxFilter) {
                            AjaxFilter filter = (AjaxFilter)obj;
                            ajaxFilterManager.addAjaxFilter(filter, scriptName);
                            continue;
                        }
                        throw new IllegalArgumentException(Messages.getString("SpringConfigurator.InvalidFilter", scriptName, obj));
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        if (this.converters != null) {
            try {
                for (Map.Entry<String, Object> entry : this.converters.entrySet()) {
                    String match = entry.getKey();
                    ConverterConfig converterConfig = (ConverterConfig)entry.getValue();
                    Map<String, String> params = converterConfig.getParams();
                    if (!converterConfig.getIncludes().isEmpty()) {
                        params.put("include", StringUtils.collectionToCommaDelimitedString(converterConfig.getIncludes()));
                    }
                    if (!converterConfig.getExcludes().isEmpty()) {
                        params.put("exclude", StringUtils.collectionToCommaDelimitedString(converterConfig.getExcludes()));
                    }
                    if (StringUtils.hasText((String)converterConfig.getJavascriptClassName())) {
                        params.put("javascript", converterConfig.getJavascriptClassName());
                    }
                    converterManager.addConverter(match, converterConfig.getType(), params);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(Messages.getString("SpringConfigurator.ConfigureConverterError"));
            }
        }
        if (StringUtils.hasText((String)this.signatures)) {
            SignatureParser sigp = new SignatureParser(converterManager, creatorManager);
            sigp.parse(this.signatures);
        }
    }

    public void setCreatorTypes(Map<String, String> creatorTypes) {
        this.creatorTypes = creatorTypes;
    }

    public void setConverterTypes(Map<String, String> converterTypes) {
        this.converterTypes = converterTypes;
    }

    public void setCreators(Map<String, CreatorConfig> creators) {
        this.creators = creators;
    }

    public void setConverters(Map<String, ConverterConfig> converters) {
        this.converters = converters;
    }

    public void setSignatures(String signatures) {
        this.signatures = signatures;
    }

    public String getSignatures() {
        return this.signatures;
    }
}

