/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.servlet.ExceptionHandler;
import org.directwebremoting.servlet.NotFoundHandler;

public class UrlProcessor
implements Handler,
InitializingBean {
    protected String indexHandlerUrl;
    protected Map<String, Object> urlMapping = new HashMap<String, Object>();
    protected Handler notFoundHandler = new NotFoundHandler();
    protected ExceptionHandler exceptionHandler = new ExceptionHandler();
    protected String contextPath = null;
    private static final Log log = LogFactory.getLog(UrlProcessor.class);

    public void afterContainerSetup(Container container) {
        Collection<String> beanNames = container.getBeanNames();
        for (String name : beanNames) {
            if (!name.startsWith("url:")) continue;
            Object bean = container.getBean(name);
            if (bean instanceof Handler) {
                this.urlMapping.put(name.substring("url:".length()), bean);
                continue;
            }
            log.error((Object)("Discarding non Handler for " + name));
        }
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String pathInfo = request.getPathInfo();
            this.contextPath = request.getContextPath();
            if (pathInfo == null || pathInfo.length() == 0 || "/".equals(pathInfo)) {
                response.sendRedirect(this.contextPath + request.getServletPath() + this.indexHandlerUrl);
            } else {
                for (Map.Entry<String, Object> entry : this.urlMapping.entrySet()) {
                    String url = entry.getKey();
                    if (!pathInfo.startsWith(url)) continue;
                    Handler handler = (Handler)entry.getValue();
                    handler.handle(request, response);
                    return;
                }
                this.notFoundHandler.handle(request, response);
            }
        }
        catch (Exception ex) {
            this.exceptionHandler.setException(ex);
            this.exceptionHandler.handle(request, response);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setIndexHandlerUrl(String indexHandlerUrl) {
        this.indexHandlerUrl = indexHandlerUrl;
    }
}

