/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.FileGenerator;
import org.directwebremoting.util.IdGenerator;

public abstract class PurgingDownloadManager
implements DownloadManager {
    protected static ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1);
    protected DownloadPurge downloadPurge = new DownloadPurge();
    protected int queueSleepTime = 15000;
    protected long purgeDownloadsAfter = 120000L;
    protected String downloadHandlerUrl;
    protected IdGenerator idGenerator = new IdGenerator();
    protected static final Log log = LogFactory.getLog(PurgingDownloadManager.class);

    public PurgingDownloadManager() {
        timer.scheduleWithFixedDelay(this.downloadPurge, this.queueSleepTime, this.queueSleepTime, TimeUnit.MILLISECONDS);
    }

    public String addFile(FileGenerator generator) throws IOException {
        String id = this.idGenerator.generateId(16);
        this.putFileGenerator(id, generator);
        HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
        return "'" + request.getContextPath() + request.getServletPath() + this.downloadHandlerUrl + id + "'";
    }

    public FileGenerator getFile(String id) {
        return this.getFileGenerator(id);
    }

    public void setDownloadHandlerUrl(String downloadHandlerUrl) {
        this.downloadHandlerUrl = downloadHandlerUrl;
    }

    public void setPurgeDownloadsAfter(long purgeDownloadsAfter) {
        this.purgeDownloadsAfter = purgeDownloadsAfter;
    }

    protected abstract void putFileGenerator(String var1, FileGenerator var2);

    protected abstract FileGenerator getFileGenerator(String var1);

    protected abstract void purge();

    public class DownloadPurge
    implements Runnable {
        public void run() {
            PurgingDownloadManager.this.purge();
        }
    }
}

