/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.Marshaller;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.util.DebuggingPrintWriter;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCallMarshaller
implements Marshaller {
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    protected String sessionCookieName = "JSESSIONID";
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    protected boolean crossDomainSessionSecurity = true;
    protected PageNormalizer pageNormalizer = null;
    protected ConverterManager converterManager = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    protected static final String ATTRIBUTE_BATCH = "org.directwebremoting.dwrp.batch";
    protected static final Log log = LogFactory.getLog(BaseCallMarshaller.class);

    @Override
    public Calls marshallInbound(HttpServletRequest request, HttpServletResponse response) throws IOException, ServerException {
        RealWebContext webContext = (RealWebContext)WebContextFactory.get();
        Batch batch = new Batch(request);
        if (!this.allowGetForSafariButMakeForgeryEasier && batch.isGet()) {
            log.error((Object)"GET is disallowed because it makes request forgery easier. See http://getahead.org/dwr/security/allowGetForSafariButMakeForgeryEasier for more details.");
            throw new SecurityException("GET Disalowed");
        }
        if (this.crossDomainSessionSecurity) {
            this.checkNotCsrfAttack(request, batch);
        }
        request.setAttribute(ATTRIBUTE_BATCH, (Object)batch);
        String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
        webContext.checkPageInformation(normalizedPage, batch.getScriptSessionId(), batch.getWindowName());
        this.storeParsedRequest(request, webContext, batch);
        return this.marshallInbound(batch);
    }

    private void checkNotCsrfAttack(HttpServletRequest request, Batch batch) {
        String headerSessionId;
        if (request.isRequestedSessionIdValid() && request.isRequestedSessionIdFromCookie() && (headerSessionId = request.getRequestedSessionId()).length() > 0) {
            String bodySessionId = batch.getHttpSessionId();
            if (headerSessionId.equals(bodySessionId)) {
                return;
            }
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals(this.sessionCookieName) || !cookie.getValue().equals(bodySessionId)) continue;
                return;
            }
            log.error((Object)"A request has been denied as a potential CSRF attack.");
            throw new SecurityException("CSRF Security Error");
        }
    }

    public Calls marshallInbound(Batch batch) {
        Calls calls = batch.getCalls();
        if (log.isDebugEnabled() && calls.getCallCount() > 0) {
            InboundContext inctx = batch.getInboundContexts().get(0);
            StringBuffer buffer = new StringBuffer();
            Iterator<String> it = inctx.getInboundVariableNames();
            while (it.hasNext()) {
                String key = it.next();
                InboundVariable value = inctx.getInboundVariable(key);
                if (!key.startsWith("c") || !key.contains("-e")) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(value.toString());
                buffer.append(", ");
            }
            if (buffer.length() > 0) {
                log.debug((Object)("Environment:  " + buffer.toString()));
            }
        }
        block5: for (int callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            InboundContext inctx = batch.getInboundContexts().get(callNum);
            Creator creator = this.creatorManager.getCreator(call.getScriptName());
            Method method = this.findMethod(call, inctx);
            if (method == null) {
                String name = call.getScriptName() + '.' + call.getMethodName();
                String error = Messages.getString("BaseCallMarshaller.UnknownMethod", name);
                log.warn((Object)("Marshalling exception: " + error));
                call.setMethod(null);
                call.setParameters(null);
                call.setException(new IllegalArgumentException(error));
                continue;
            }
            call.setMethod(method);
            this.accessControl.assertExecutionIsPossible(creator, call.getScriptName(), method);
            try {
                inctx.dereference();
            }
            catch (MarshallException ex) {
                log.warn((Object)"Marshalling exception", (Throwable)ex);
                call.setMethod(null);
                call.setParameters(null);
                call.setException(ex);
                continue;
            }
            Object[] params = new Object[method.getParameterTypes().length];
            for (int j = 0; j < method.getParameterTypes().length; ++j) {
                try {
                    Class<?> paramType = method.getParameterTypes()[j];
                    InboundVariable param = inctx.getParameter(callNum, j);
                    TypeHintContext incc = new TypeHintContext(this.converterManager, method, j);
                    params[j] = this.converterManager.convertInbound(paramType, param, inctx, incc);
                    continue;
                }
                catch (MarshallException ex) {
                    log.warn((Object)"Marshalling exception", (Throwable)ex);
                    call.setMethod(null);
                    call.setParameters(null);
                    call.setException(ex);
                    continue block5;
                }
            }
            call.setParameters(params);
        }
        return calls;
    }

    private void storeParsedRequest(HttpServletRequest request, RealWebContext webContext, Batch batch) {
        Map<String, FormField> paramMap = batch.getSpareParameters();
        if (!paramMap.isEmpty()) {
            for (Map.Entry<String, FormField> entry : paramMap.entrySet()) {
                String key = entry.getKey();
                FormField formField = entry.getValue();
                Object value = formField.isFile() ? new FileTransfer(formField.getName(), formField.getMimeType(), formField.getInputStream()) : formField.getString();
                request.setAttribute(key, value);
                log.debug((Object)("Moved param to request: " + key + "=" + value));
            }
        }
    }

    private Method findMethod(Call call, InboundContext inctx) {
        if (call.getScriptName() == null) {
            throw new IllegalArgumentException(Messages.getString("BaseCallMarshaller.MissingClassParam"));
        }
        if (call.getMethodName() == null) {
            throw new IllegalArgumentException(Messages.getString("BaseCallMarshaller.MissingMethodParam"));
        }
        Creator creator = this.creatorManager.getCreator(call.getScriptName());
        ArrayList<Method> available = new ArrayList<Method>();
        block0: for (Method method : creator.getType().getMethods()) {
            if (!method.getName().equals(call.getMethodName()) || method.getParameterTypes().length != inctx.getParameterCount()) continue;
            inctx.clearConverted();
            for (int j = 0; j < method.getParameterTypes().length; ++j) {
                Class<?> paramType = method.getParameterTypes()[j];
                if (!this.converterManager.isConvertable(paramType)) continue block0;
            }
            available.add(method);
        }
        if (available.size() > 1) {
            log.warn((Object)"Warning multiple matching methods. Using first match.");
        }
        if (available.isEmpty()) {
            return null;
        }
        return (Method)available.get(0);
    }

    @Override
    public void marshallOutbound(Replies replies, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = this.debugScriptOutput && log.isDebugEnabled() ? new DebuggingPrintWriter("", response.getWriter()) : response.getWriter();
        CallScriptConduit conduit = new CallScriptConduit(out);
        if (out instanceof DebuggingPrintWriter) {
            DebuggingPrintWriter dpw = (DebuggingPrintWriter)out;
            dpw.setPrefix("out(" + conduit.hashCode() + "): ");
        }
        this.sendOutboundScriptPrefix(out, replies.getBatchId());
        RealScriptSession scriptSession = (RealScriptSession)WebContextFactory.get().getScriptSession();
        out.println("//#DWR-INSERT");
        scriptSession.writeScripts(conduit);
        out.println("//#DWR-REPLY");
        String batchId = replies.getBatchId();
        for (int i = 0; i < replies.getReplyCount(); ++i) {
            Reply reply = replies.getReply(i);
            String callId = reply.getCallId();
            try {
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    EnginePrivate.remoteHandleException(conduit, batchId, callId, ex);
                    log.warn((Object)("--Erroring: batchId[" + batchId + "] message[" + ex.toString() + ']'));
                    continue;
                }
                Object data = reply.getReply();
                EnginePrivate.remoteHandleCallback(conduit, batchId, callId, data);
                continue;
            }
            catch (IOException ex) {
                log.error((Object)("--Output Error: batchId[" + batchId + "] message[" + ex.toString() + ']'), (Throwable)ex);
                continue;
            }
            catch (MarshallException ex) {
                EnginePrivate.remoteHandleException(conduit, batchId, callId, ex);
                log.warn((Object)("--MarshallException: batchId=" + batchId + " class=" + ex.getConversionType().getName()), (Throwable)ex);
                continue;
            }
            catch (Exception ex) {
                EnginePrivate.remoteHandleException(conduit, batchId, callId, ex);
                log.error((Object)("--MarshallException: batchId=" + batchId + " message=" + ex.toString()));
            }
        }
        this.sendOutboundScriptSuffix(out, replies.getBatchId());
    }

    @Override
    public void marshallException(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = response.getWriter();
        Batch batch = (Batch)request.getAttribute(ATTRIBUTE_BATCH);
        String batchId = batch != null && batch.getCalls() != null ? batch.getCalls().getBatchId() : null;
        this.sendOutboundScriptPrefix(out, batchId);
        String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, ex);
        out.print(script);
        this.sendOutboundScriptSuffix(out, batchId);
    }

    protected abstract void sendScript(PrintWriter var1, String var2) throws IOException;

    protected abstract String getOutboundMimeType();

    protected abstract void sendOutboundScriptPrefix(PrintWriter var1, String var2) throws IOException;

    protected abstract void sendOutboundScriptSuffix(PrintWriter var1, String var2) throws IOException;

    @Override
    public boolean isConvertable(Class<?> paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setCrossDomainSessionSecurity(boolean crossDomainSessionSecurity) {
        this.crossDomainSessionSecurity = crossDomainSessionSecurity;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }

    protected class CallScriptConduit
    extends ScriptConduit {
        private final PrintWriter out;

        protected CallScriptConduit(PrintWriter out) {
            super(5);
            if (out == null) {
                throw new NullPointerException("out=null");
            }
            this.out = out;
        }

        public boolean addScript(ScriptBuffer script) throws IOException, MarshallException {
            BaseCallMarshaller.this.sendScript(this.out, ScriptBufferUtil.createOutput(script, BaseCallMarshaller.this.converterManager, BaseCallMarshaller.this.jsonOutput));
            return true;
        }
    }
}

