/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.dbunit.util.concurrent.BoundedChannel;
import org.dbunit.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SemaphoreControlledChannel
implements BoundedChannel {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$util$concurrent$SemaphoreControlledChannel == null ? (class$org$dbunit$util$concurrent$SemaphoreControlledChannel = SemaphoreControlledChannel.class$("org.dbunit.util.concurrent.SemaphoreControlledChannel")) : class$org$dbunit$util$concurrent$SemaphoreControlledChannel));
    protected final Semaphore putGuard_;
    protected final Semaphore takeGuard_;
    protected int capacity_;
    static /* synthetic */ Class class$org$dbunit$util$concurrent$SemaphoreControlledChannel;

    public SemaphoreControlledChannel(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        this.putGuard_ = new Semaphore(capacity);
        this.takeGuard_ = new Semaphore(0L);
    }

    public SemaphoreControlledChannel(int capacity, Class semaphoreClass) throws IllegalArgumentException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        Class[] longarg = new Class[]{Long.TYPE};
        Constructor ctor = semaphoreClass.getDeclaredConstructor(longarg);
        Object[] cap = new Long[]{new Long(capacity)};
        this.putGuard_ = (Semaphore)ctor.newInstance(cap);
        Object[] zero = new Long[]{new Long(0L)};
        this.takeGuard_ = (Semaphore)ctor.newInstance(zero);
    }

    public int capacity() {
        logger.debug("capacity() - start");
        return this.capacity_;
    }

    public int size() {
        logger.debug("size() - start");
        return (int)this.takeGuard_.permits();
    }

    protected abstract void insert(Object var1);

    protected abstract Object extract();

    public void put(Object x) throws InterruptedException {
        logger.debug("put(x=" + x + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.putGuard_.acquire();
        try {
            this.insert(x);
            this.takeGuard_.release();
        }
        catch (ClassCastException ex) {
            logger.error("put()", (Throwable)ex);
            this.putGuard_.release();
            throw ex;
        }
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        logger.debug("offer(x=" + x + ", msecs=" + msecs + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.putGuard_.attempt(msecs)) {
            return false;
        }
        try {
            this.insert(x);
            this.takeGuard_.release();
            return true;
        }
        catch (ClassCastException ex) {
            logger.error("offer()", (Throwable)ex);
            this.putGuard_.release();
            throw ex;
        }
    }

    public Object take() throws InterruptedException {
        logger.debug("take() - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.takeGuard_.acquire();
        try {
            Object x = this.extract();
            this.putGuard_.release();
            return x;
        }
        catch (ClassCastException ex) {
            logger.error("take()", (Throwable)ex);
            this.takeGuard_.release();
            throw ex;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        logger.debug("poll(msecs=" + msecs + ") - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.takeGuard_.attempt(msecs)) {
            return null;
        }
        try {
            Object x = this.extract();
            this.putGuard_.release();
            return x;
        }
        catch (ClassCastException ex) {
            logger.error("poll()", (Throwable)ex);
            this.takeGuard_.release();
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

