/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import org.dbunit.util.concurrent.BoundedChannel;
import org.dbunit.util.concurrent.DefaultChannelCapacity;
import org.dbunit.util.concurrent.LinkedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedLinkedQueue
implements BoundedChannel {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$util$concurrent$BoundedLinkedQueue == null ? (class$org$dbunit$util$concurrent$BoundedLinkedQueue = BoundedLinkedQueue.class$("org.dbunit.util.concurrent.BoundedLinkedQueue")) : class$org$dbunit$util$concurrent$BoundedLinkedQueue));
    protected LinkedNode head_;
    protected LinkedNode last_;
    protected final Object putGuard_ = new Object();
    protected final Object takeGuard_ = new Object();
    protected int capacity_;
    protected int putSidePutPermits_;
    protected int takeSidePutPermits_ = 0;
    static /* synthetic */ Class class$org$dbunit$util$concurrent$BoundedLinkedQueue;

    public BoundedLinkedQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        this.putSidePutPermits_ = capacity;
        this.last_ = this.head_ = new LinkedNode(null);
    }

    public BoundedLinkedQueue() {
        this(DefaultChannelCapacity.get());
    }

    protected final int reconcilePutPermits() {
        logger.debug("reconcilePutPermits() - start");
        this.putSidePutPermits_ += this.takeSidePutPermits_;
        this.takeSidePutPermits_ = 0;
        return this.putSidePutPermits_;
    }

    public synchronized int capacity() {
        logger.debug("capacity() - start");
        return this.capacity_;
    }

    public synchronized int size() {
        logger.debug("size() - start");
        return this.capacity_ - (this.takeSidePutPermits_ + this.putSidePutPermits_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int newCapacity) {
        logger.debug("setCapacity(newCapacity=" + newCapacity + ") - start");
        if (newCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.putGuard_;
        synchronized (object) {
            BoundedLinkedQueue boundedLinkedQueue = this;
            synchronized (boundedLinkedQueue) {
                this.takeSidePutPermits_ += newCapacity - this.capacity_;
                this.capacity_ = newCapacity;
                this.reconcilePutPermits();
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object extract() {
        logger.debug("extract() - start");
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            Object x = null;
            LinkedNode first = this.head_.next;
            if (first != null) {
                x = first.value;
                first.value = null;
                this.head_ = first;
                ++this.takeSidePutPermits_;
                this.notify();
            }
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        logger.debug("peek() - start");
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            LinkedNode first = this.head_.next;
            if (first != null) {
                return first.value;
            }
            return null;
        }
    }

    public Object take() throws InterruptedException {
        logger.debug("take() - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.takeGuard_;
        synchronized (object) {
            try {
                while (true) {
                    if ((x = this.extract()) != null) {
                        return x;
                    }
                    this.takeGuard_.wait();
                }
            }
            catch (InterruptedException ex) {
                logger.error("take()", (Throwable)ex);
                this.takeGuard_.notify();
                throw ex;
            }
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        logger.debug("poll(msecs=" + msecs + ") - start");
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object x = this.extract();
        if (x != null) {
            return x;
        }
        Object object = this.takeGuard_;
        synchronized (object) {
            try {
                long start;
                long waitTime = msecs;
                long l = start = msecs <= 0L ? 0L : System.currentTimeMillis();
                while (true) {
                    if ((x = this.extract()) != null || waitTime <= 0L) {
                        return x;
                    }
                    this.takeGuard_.wait(waitTime);
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
            }
            catch (InterruptedException ex) {
                logger.error("poll()", (Throwable)ex);
                this.takeGuard_.notify();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void allowTake() {
        logger.debug("allowTake() - start");
        Object object = this.takeGuard_;
        synchronized (object) {
            this.takeGuard_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(Object x) {
        logger.debug("insert(x=" + x + ") - start");
        --this.putSidePutPermits_;
        LinkedNode p = new LinkedNode(x);
        LinkedNode linkedNode = this.last_;
        synchronized (linkedNode) {
            this.last_.next = p;
            this.last_ = p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object x) throws InterruptedException {
        logger.debug("put(x=" + x + ") - start");
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.putGuard_;
        synchronized (object) {
            if (this.putSidePutPermits_ <= 0) {
                BoundedLinkedQueue boundedLinkedQueue = this;
                synchronized (boundedLinkedQueue) {
                    if (this.reconcilePutPermits() <= 0) {
                        try {
                            do {
                                this.wait();
                            } while (this.reconcilePutPermits() <= 0);
                        }
                        catch (InterruptedException ex) {
                            logger.error("put()", (Throwable)ex);
                            this.notify();
                            throw ex;
                        }
                    }
                }
            }
            this.insert(x);
        }
        this.allowTake();
    }

    /*
     * Exception decompiling
     */
    public boolean offer(Object x, long msecs) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        logger.debug("isEmpty() - start");
        LinkedNode linkedNode = this.head_;
        synchronized (linkedNode) {
            return this.head_.next == null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

