/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.ExclusiveTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOperation
extends DatabaseOperation {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$operation$TransactionOperation == null ? (class$org$dbunit$operation$TransactionOperation = TransactionOperation.class$("org.dbunit.operation.TransactionOperation")) : class$org$dbunit$operation$TransactionOperation));
    private final DatabaseOperation _operation;
    static /* synthetic */ Class class$org$dbunit$operation$TransactionOperation;

    public TransactionOperation(DatabaseOperation operation) {
        this._operation = operation;
    }

    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection=" + connection + ", dataSet=" + dataSet + ") - start");
        IDatabaseConnection databaseConnection = connection;
        Connection jdbcConnection = databaseConnection.getConnection();
        if (!jdbcConnection.getAutoCommit()) {
            throw new ExclusiveTransactionException();
        }
        jdbcConnection.setAutoCommit(false);
        try {
            this._operation.execute(databaseConnection, dataSet);
            jdbcConnection.commit();
        }
        catch (DatabaseUnitException e) {
            logger.error("execute()", (Throwable)e);
            jdbcConnection.rollback();
            throw e;
        }
        catch (SQLException e) {
            logger.error("execute()", (Throwable)e);
            jdbcConnection.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("execute()", (Throwable)e);
            jdbcConnection.rollback();
            throw e;
        }
        finally {
            jdbcConnection.setAutoCommit(true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

