/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlProducer
extends DefaultHandler
implements IDataSetProducer,
ContentHandler,
ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$xml$XmlProducer == null ? (class$org$dbunit$dataset$xml$XmlProducer = XmlProducer.class$("org.dbunit.dataset.xml.XmlProducer")) : class$org$dbunit$dataset$xml$XmlProducer));
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String DATASET = "dataset";
    private static final String TABLE = "table";
    private static final String NAME = "name";
    private static final String COLUMN = "column";
    private static final String ROW = "row";
    private static final String VALUE = "value";
    private static final String NULL = "null";
    private static final String NONE = "none";
    private final InputSource _inputSource;
    private boolean _validating = false;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private String _activeTableName;
    private ITableMetaData _activeMetaData;
    private List _activeColumnNames;
    private StringBuffer _activeCharacters;
    private List _activeRowValues;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$XmlProducer;

    public XmlProducer(InputSource inputSource) {
        this._inputSource = inputSource;
    }

    private ITableMetaData createMetaData(String tableName, List _columnNames) {
        logger.debug("createMetaData(tableName=" + tableName + ", _columnNames=" + _columnNames + ") - start");
        Column[] columns = new Column[_columnNames.size()];
        for (int i = 0; i < columns.length; ++i) {
            String columnName = (String)_columnNames.get(i);
            columns[i] = new Column(columnName, DataType.UNKNOWN);
        }
        DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
        return metaData;
    }

    public void setValidating(boolean validating) {
        logger.debug("setValidating(validating=" + validating + ") - start");
        this._validating = validating;
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(this._validating);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setEntityResolver(this);
            xmlReader.setErrorHandler(this);
            xmlReader.parse(this._inputSource);
        }
        catch (ParserConfigurationException e) {
            logger.error("produce()", (Throwable)e);
            throw new DataSetException(e);
        }
        catch (SAXException e) {
            logger.error("produce()", (Throwable)e);
            Exception exception = e.getException() == null ? e : e.getException();
            throw new DataSetException(exception);
        }
        catch (IOException e) {
            logger.error("produce()", (Throwable)e);
            throw new DataSetException(e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        logger.debug("resolveEntity(publicId=" + publicId + ", systemId=" + systemId + ") - start");
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("org/dbunit/dataset/xml/dataset.dtd");
        return new InputSource(in);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        logger.debug("startElement(uri=" + uri + ", localName=" + localName + ", qName=" + qName + ", attributes=" + attributes + ") - start");
        try {
            if (qName.equals(DATASET)) {
                this._consumer.startDataSet();
                return;
            }
            if (qName.equals(TABLE)) {
                this._activeTableName = attributes.getValue(NAME);
                this._activeColumnNames = new LinkedList();
                return;
            }
            if (qName.equals(COLUMN)) {
                this._activeCharacters = new StringBuffer();
                return;
            }
            if (qName.equals(ROW)) {
                if (this._activeColumnNames != null) {
                    this._activeMetaData = this.createMetaData(this._activeTableName, this._activeColumnNames);
                    this._consumer.startTable(this._activeMetaData);
                    this._activeColumnNames = null;
                }
                this._activeRowValues = new LinkedList();
                return;
            }
            if (qName.equals(VALUE)) {
                this._activeCharacters = new StringBuffer();
                return;
            }
            if (qName.equals(NULL)) {
                this._activeRowValues.add(null);
                return;
            }
            if (qName.equals(NONE)) {
                this._activeRowValues.add(ITable.NO_VALUE);
                return;
            }
        }
        catch (DataSetException e) {
            logger.error("startElement()", (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        logger.debug("endElement(uri=" + uri + ", localName=" + localName + ", qName=" + qName + ") - start");
        try {
            if (qName.equals(DATASET)) {
                this._consumer.endDataSet();
                return;
            }
            if (qName.equals(TABLE)) {
                if (this._activeColumnNames != null) {
                    this._activeMetaData = this.createMetaData(this._activeTableName, this._activeColumnNames);
                    this._consumer.startTable(this._activeMetaData);
                    this._activeColumnNames = null;
                }
                this._consumer.endTable();
                this._activeTableName = null;
                this._activeMetaData = null;
                return;
            }
            if (qName.equals(COLUMN)) {
                this._activeColumnNames.add(this._activeCharacters.toString());
                this._activeCharacters = null;
                return;
            }
            if (qName.equals(ROW)) {
                int length = Math.max(this._activeRowValues.size(), this._activeMetaData.getColumns().length);
                Object[] values = new Object[length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = i >= this._activeRowValues.size() ? ITable.NO_VALUE : this._activeRowValues.get(i);
                }
                this._consumer.row(values);
                this._activeRowValues = null;
                return;
            }
            if (qName.equals(VALUE)) {
                this._activeRowValues.add(this._activeCharacters.toString());
                this._activeCharacters = null;
                return;
            }
            if (qName.equals(NULL)) {
                return;
            }
            if (qName.equals(NONE)) {
                return;
            }
        }
        catch (DataSetException e) {
            logger.error("endElement()", (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        logger.debug("characters(ch=" + ch + ", start=" + start + ", length=" + length + ") - start");
        if (this._activeCharacters != null) {
            this._activeCharacters.append(ch, start, length);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        logger.debug("error(e=" + e + ") - start");
        throw e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

