/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.util.xml.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatXmlWriter
implements IDataSetConsumer {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$xml$FlatXmlWriter == null ? (class$org$dbunit$dataset$xml$FlatXmlWriter = FlatXmlWriter.class$("org.dbunit.dataset.xml.FlatXmlWriter")) : class$org$dbunit$dataset$xml$FlatXmlWriter));
    private static final String DEFAULT_ENCODING = "UTF8";
    private static final String DATASET = "dataset";
    private XmlWriter _xmlWriter;
    private ITableMetaData _activeMetaData;
    private int _activeRowCount;
    private boolean _includeEmptyTable = false;
    private String _systemId = null;
    static /* synthetic */ Class class$org$dbunit$dataset$xml$FlatXmlWriter;

    public FlatXmlWriter(Writer writer) {
        this._xmlWriter = new XmlWriter(writer);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public FlatXmlWriter(OutputStream out) throws IOException {
        this._xmlWriter = new XmlWriter(new OutputStreamWriter(out, DEFAULT_ENCODING));
        this._xmlWriter.enablePrettyPrint(true);
    }

    public FlatXmlWriter(Writer writer, String encoding) {
        this._xmlWriter = new XmlWriter(writer, encoding);
        this._xmlWriter.enablePrettyPrint(true);
    }

    public void setIncludeEmptyTable(boolean includeEmptyTable) {
        logger.debug("setIncludeEmptyTable(includeEmptyTable=" + includeEmptyTable + ") - start");
        this._includeEmptyTable = includeEmptyTable;
    }

    public void setDocType(String systemId) {
        logger.debug("setDocType(systemId=" + systemId + ") - start");
        this._systemId = systemId;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        logger.debug("write(dataSet=" + dataSet + ") - start");
        DataSetProducerAdapter provider = new DataSetProducerAdapter(dataSet);
        provider.setConsumer(this);
        provider.produce();
    }

    public void startDataSet() throws DataSetException {
        logger.debug("startDataSet() - start");
        try {
            this._xmlWriter.writeDeclaration();
            this._xmlWriter.writeDoctype(this._systemId, null);
            this._xmlWriter.writeElement(DATASET);
        }
        catch (IOException e) {
            logger.error("startDataSet()", (Throwable)e);
            throw new DataSetException(e);
        }
    }

    public void endDataSet() throws DataSetException {
        logger.debug("endDataSet() - start");
        try {
            this._xmlWriter.endElement();
            this._xmlWriter.close();
        }
        catch (IOException e) {
            logger.error("endDataSet()", (Throwable)e);
            throw new DataSetException(e);
        }
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        logger.debug("startTable(metaData=" + metaData + ") - start");
        this._activeMetaData = metaData;
        this._activeRowCount = 0;
    }

    public void endTable() throws DataSetException {
        logger.debug("endTable() - start");
        if (this._includeEmptyTable && this._activeRowCount == 0) {
            try {
                String tableName = this._activeMetaData.getTableName();
                this._xmlWriter.writeEmptyElement(tableName);
            }
            catch (IOException e) {
                logger.error("endTable()", (Throwable)e);
                throw new DataSetException(e);
            }
        }
        this._activeMetaData = null;
    }

    public void row(Object[] values) throws DataSetException {
        logger.debug("row(values=" + values + ") - start");
        try {
            String tableName = this._activeMetaData.getTableName();
            this._xmlWriter.writeElement(tableName);
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                Object value = values[i];
                if (value == null) continue;
                try {
                    String stringValue = DataType.asString(value);
                    this._xmlWriter.writeAttribute(columnName, stringValue);
                    continue;
                }
                catch (TypeCastException e) {
                    logger.error("row()", (Throwable)e);
                    throw new DataSetException("table=" + this._activeMetaData.getTableName() + ", row=" + i + ", column=" + columnName + ", value=" + value, e);
                }
            }
            ++this._activeRowCount;
            this._xmlWriter.endElement();
        }
        catch (IOException e) {
            logger.error("row()", (Throwable)e);
            throw new DataSetException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

