/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.stream;

import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.util.concurrent.BoundedBuffer;
import org.dbunit.util.concurrent.Puttable;
import org.dbunit.util.concurrent.Takable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingIterator
implements ITableIterator {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$stream$StreamingIterator == null ? (class$org$dbunit$dataset$stream$StreamingIterator = StreamingIterator.class$("org.dbunit.dataset.stream.StreamingIterator")) : class$org$dbunit$dataset$stream$StreamingIterator));
    private static final Object EOD = new Object();
    private final Takable _channel;
    private StreamingTable _activeTable;
    private Object _taken = null;
    private boolean _eod = false;
    static /* synthetic */ Class class$org$dbunit$dataset$stream$StreamingIterator;
    static /* synthetic */ Class class$org$dbunit$dataset$stream$StreamingIterator$StreamingTable;
    static /* synthetic */ Class class$org$dbunit$dataset$stream$StreamingIterator$AsynchronousConsumer;

    public StreamingIterator(IDataSetProducer source) throws DataSetException {
        BoundedBuffer channel = new BoundedBuffer(30);
        this._channel = channel;
        AsynchronousConsumer consumer = new AsynchronousConsumer(source, channel);
        Thread thread = new Thread(consumer);
        thread.setDaemon(true);
        thread.start();
        try {
            this._taken = this._channel.take();
        }
        catch (InterruptedException e) {
            logger.error("StreamingIterator()", (Throwable)e);
            throw new DataSetException(e);
        }
    }

    public boolean next() throws DataSetException {
        logger.debug("next() - start");
        if (this._eod) {
            return false;
        }
        while (this._activeTable != null && this._activeTable.next()) {
        }
        if (this._taken == EOD) {
            this._eod = true;
            this._activeTable = null;
            return false;
        }
        if (this._taken instanceof ITableMetaData) {
            this._activeTable = new StreamingTable((ITableMetaData)this._taken);
            return true;
        }
        throw new IllegalStateException("Unexpected object taken from asyncronous handler: " + this._taken);
    }

    public ITableMetaData getTableMetaData() throws DataSetException {
        logger.debug("getTableMetaData() - start");
        return this._activeTable.getTableMetaData();
    }

    public ITable getTable() throws DataSetException {
        logger.debug("getTable() - start");
        return this._activeTable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AsynchronousConsumer
    implements Runnable,
    IDataSetConsumer {
        private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$stream$StreamingIterator$AsynchronousConsumer == null ? (class$org$dbunit$dataset$stream$StreamingIterator$AsynchronousConsumer = StreamingIterator.class$("org.dbunit.dataset.stream.StreamingIterator$AsynchronousConsumer")) : class$org$dbunit$dataset$stream$StreamingIterator$AsynchronousConsumer));
        private final IDataSetProducer _producer;
        private final Puttable _channel;

        public AsynchronousConsumer(IDataSetProducer source, Puttable channel) {
            this._producer = source;
            this._channel = channel;
        }

        public void run() {
            logger.debug("run() - start");
            try {
                this._producer.setConsumer(this);
                this._producer.produce();
            }
            catch (DataSetException e) {
                logger.error("run()", (Throwable)e);
                throw new DatabaseUnitRuntimeException(e);
            }
        }

        public void startDataSet() throws DataSetException {
        }

        public void endDataSet() throws DataSetException {
            logger.debug("endDataSet() - start");
            try {
                this._channel.put(EOD);
            }
            catch (InterruptedException e) {
                logger.error("endDataSet()", (Throwable)e);
                throw new DataSetException();
            }
        }

        public void startTable(ITableMetaData metaData) throws DataSetException {
            logger.debug("startTable(metaData=" + metaData + ") - start");
            try {
                this._channel.put(metaData);
            }
            catch (InterruptedException e) {
                logger.error("startTable()", (Throwable)e);
                throw new DataSetException();
            }
        }

        public void endTable() throws DataSetException {
        }

        public void row(Object[] values) throws DataSetException {
            logger.debug("row(values=" + values + ") - start");
            try {
                this._channel.put(values);
            }
            catch (InterruptedException e) {
                logger.error("row()", (Throwable)e);
                throw new DataSetException();
            }
        }
    }

    private class StreamingTable
    extends AbstractTable {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$stream$StreamingIterator$StreamingTable == null ? (class$org$dbunit$dataset$stream$StreamingIterator$StreamingTable = StreamingIterator.class$("org.dbunit.dataset.stream.StreamingIterator$StreamingTable")) : class$org$dbunit$dataset$stream$StreamingIterator$StreamingTable));
        private ITableMetaData _metaData;
        private int _lastRow = -1;
        private boolean _eot = false;
        private Object[] _rowValues;

        public StreamingTable(ITableMetaData metaData) {
            this._metaData = metaData;
        }

        boolean next() throws DataSetException {
            this.logger.debug("next() - start");
            if (this._eot) {
                return false;
            }
            try {
                StreamingIterator.this._taken = StreamingIterator.this._channel.take();
                if (!(StreamingIterator.this._taken instanceof Object[])) {
                    this._eot = true;
                    return false;
                }
                ++this._lastRow;
                this._rowValues = (Object[])StreamingIterator.this._taken;
                return true;
            }
            catch (InterruptedException e) {
                this.logger.error("next()", (Throwable)e);
                throw new DataSetException();
            }
        }

        public ITableMetaData getTableMetaData() {
            this.logger.debug("getTableMetaData() - start");
            return this._metaData;
        }

        public int getRowCount() {
            this.logger.debug("getRowCount() - start");
            throw new UnsupportedOperationException();
        }

        public Object getValue(int row, String column) throws DataSetException {
            this.logger.debug("getValue(row=" + row + ", column=" + column + ") - start");
            while (!this._eot && row > this._lastRow) {
                this.next();
            }
            if (row < this._lastRow) {
                throw new UnsupportedOperationException("Cannot go backward!");
            }
            if (this._eot || row > this._lastRow) {
                throw new RowOutOfBoundsException(row + " > " + this._lastRow);
            }
            return this._rowValues[this.getColumnIndex(column)];
        }
    }
}

