/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$datatype$NumberDataType == null ? (class$org$dbunit$dataset$datatype$NumberDataType = NumberDataType.class$("org.dbunit.dataset.datatype.NumberDataType")) : class$org$dbunit$dataset$datatype$NumberDataType));
    private static final Number TRUE = new BigDecimal(1.0);
    private static final Number FALSE = new BigDecimal(0.0);
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$NumberDataType;
    static /* synthetic */ Class class$java$math$BigDecimal;

    NumberDataType(String name, int sqlType) {
        super(name, sqlType, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberDataType.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, true);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value=" + value + ") - start");
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? (Number)TRUE : (Number)FALSE;
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException e) {
            logger.error("typeCast()", (Throwable)e);
            throw new TypeCastException(value, this, e);
        }
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        BigDecimal value = resultSet.getBigDecimal(column);
        if (value == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        statement.setBigDecimal(column, (BigDecimal)this.typeCast(value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

