/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$datatype$DoubleDataType == null ? (class$org$dbunit$dataset$datatype$DoubleDataType = DoubleDataType.class$("org.dbunit.dataset.datatype.DoubleDataType")) : class$org$dbunit$dataset$datatype$DoubleDataType));
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$DoubleDataType;
    static /* synthetic */ Class class$java$lang$Double;

    DoubleDataType(String name, int sqlType) {
        super(name, sqlType, class$java$lang$Double == null ? (class$java$lang$Double = DoubleDataType.class$("java.lang.Double")) : class$java$lang$Double, true);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value=" + value + ") - start");
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        try {
            return this.typeCast(new BigDecimal(value.toString()));
        }
        catch (NumberFormatException e) {
            logger.error("typeCast()", (Throwable)e);
            throw new TypeCastException(value, this, e);
        }
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        double value = resultSet.getDouble(column);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Double(value);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        statement.setDouble(column, ((Number)this.typeCast(value)).doubleValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

