/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$datatype$BytesDataType == null ? (class$org$dbunit$dataset$datatype$BytesDataType = BytesDataType.class$("org.dbunit.dataset.datatype.BytesDataType")) : class$org$dbunit$dataset$datatype$BytesDataType));
    private static final int MAX_URI_LENGTH = 256;
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$BytesDataType;
    static /* synthetic */ Class array$B;

    BytesDataType(String name, int sqlType) {
        super(name, sqlType, array$B == null ? (array$B = BytesDataType.class$("[B")) : array$B, false);
    }

    private byte[] toByteArray(InputStream in, int length) throws IOException {
        logger.debug("toByteArray(in=" + in + ", length=" + length + ") - start");
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        in = new BufferedInputStream(in);
        int i = in.read();
        while (i != -1) {
            out.write(i);
            i = in.read();
        }
        return out.toByteArray();
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value=" + value + ") - start");
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof byte[]) {
            return value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.length() == 0 || stringValue.length() > 256) {
                return Base64.decode((String)value);
            }
            try {
                try {
                    URL url = new URL(stringValue);
                    return this.toByteArray(url.openStream(), 0);
                }
                catch (MalformedURLException e1) {
                    logger.error("typeCast()", (Throwable)e1);
                    try {
                        File file = new File(stringValue);
                        return this.toByteArray(new FileInputStream(file), (int)file.length());
                    }
                    catch (FileNotFoundException e2) {
                        logger.error("typeCast()", (Throwable)e2);
                        return Base64.decode((String)value);
                    }
                }
            }
            catch (IOException e) {
                logger.error("typeCast()", (Throwable)e);
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof Blob) {
            try {
                Blob blobValue = (Blob)value;
                return blobValue.getBytes(1L, (int)blobValue.length());
            }
            catch (SQLException e) {
                logger.error("typeCast()", (Throwable)e);
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof URL) {
            try {
                return this.toByteArray(((URL)value).openStream(), 0);
            }
            catch (IOException e) {
                logger.error("typeCast()", (Throwable)e);
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof File) {
            try {
                File file = (File)value;
                return this.toByteArray(new FileInputStream(file), (int)file.length());
            }
            catch (IOException e) {
                logger.error("typeCast()", (Throwable)e);
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        logger.debug("compare(o1=" + o1 + ", o2=" + o2 + ") - start");
        try {
            byte[] value1 = (byte[])this.typeCast(o1);
            byte[] value2 = (byte[])this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            return this.compare(value1, value2);
        }
        catch (ClassCastException e) {
            logger.error("compare()", (Throwable)e);
            throw new TypeCastException(e);
        }
    }

    public int compare(byte[] v1, byte[] v2) throws TypeCastException {
        logger.debug("compare(v1=" + v1 + ", v2=" + v2 + ") - start");
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        int j = 0;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                byte c1 = v1[k];
                byte c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                byte c2;
                byte c1;
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        byte[] value = resultSet.getBytes(column);
        if (value == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        super.setSqlValue(value, column, statement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

