/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BytesDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryStreamDataType
extends BytesDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$datatype$BinaryStreamDataType == null ? (class$org$dbunit$dataset$datatype$BinaryStreamDataType = BinaryStreamDataType.class$("org.dbunit.dataset.datatype.BinaryStreamDataType")) : class$org$dbunit$dataset$datatype$BinaryStreamDataType));
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$BinaryStreamDataType;

    public BinaryStreamDataType(String name, int sqlType) {
        super(name, sqlType);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        InputStream in = resultSet.getBinaryStream(column);
        if (in == null || resultSet.wasNull()) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[32];
            int length = in.read(buffer);
            while (length != -1) {
                out.write(buffer, 0, length);
                length = in.read(buffer);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            logger.error("getSqlValue()", (Throwable)e);
            throw new TypeCastException(e);
        }
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        byte[] bytes = (byte[])this.typeCast(value);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        statement.setBinaryStream(column, (InputStream)in, bytes.length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

