/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataType
extends DataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$datatype$AbstractDataType == null ? (class$org$dbunit$dataset$datatype$AbstractDataType = AbstractDataType.class$("org.dbunit.dataset.datatype.AbstractDataType")) : class$org$dbunit$dataset$datatype$AbstractDataType));
    private final String _name;
    private final int _sqlType;
    private final Class _classType;
    private final boolean _isNumber;
    static /* synthetic */ Class class$org$dbunit$dataset$datatype$AbstractDataType;

    public AbstractDataType(String name, int sqlType, Class classType, boolean isNumber) {
        this._sqlType = sqlType;
        this._name = name;
        this._classType = classType;
        this._isNumber = isNumber;
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        logger.debug("compare(o1=" + o1 + ", o2=" + o2 + ") - start");
        try {
            Comparable value1 = (Comparable)this.typeCast(o1);
            Comparable value2 = (Comparable)this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            return value1.compareTo(value2);
        }
        catch (ClassCastException e) {
            logger.error("compare()", (Throwable)e);
            throw new TypeCastException(e);
        }
    }

    public int getSqlType() {
        logger.debug("getSqlType() - start");
        return this._sqlType;
    }

    public Class getTypeClass() {
        logger.debug("getTypeClass() - start");
        return this._classType;
    }

    public boolean isNumber() {
        logger.debug("isNumber() - start");
        return this._isNumber;
    }

    public boolean isDateTime() {
        logger.debug("isDateTime() - start");
        return false;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        logger.debug("getSqlValue(column=" + column + ", resultSet=" + resultSet + ") - start");
        Object value = resultSet.getObject(column);
        if (value == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        logger.debug("setSqlValue(value=" + value + ", column=" + column + ", statement=" + statement + ") - start");
        statement.setObject(column, this.typeCast(value), this.getSqlType());
    }

    public String toString() {
        logger.debug("toString() - start");
        return this._name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

