/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv.handlers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.Handler;
import org.dbunit.dataset.csv.handlers.NoHandler;
import org.dbunit.dataset.csv.handlers.PipelineComponent;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.csv.handlers.TransparentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$csv$handlers$Pipeline == null ? (class$org$dbunit$dataset$csv$handlers$Pipeline = Pipeline.class$("org.dbunit.dataset.csv.handlers.Pipeline")) : class$org$dbunit$dataset$csv$handlers$Pipeline));
    private LinkedList components;
    private List products;
    private StringBuffer currentProduct;
    private PipelineComponent noHandler;
    static /* synthetic */ Class class$org$dbunit$dataset$csv$handlers$Pipeline;

    public Pipeline() {
        this.setComponents(new LinkedList());
        this.setProducts(new ArrayList());
        this.setNoHandler(NoHandler.IGNORE());
        this.getNoHandler().setSuccessor(null);
        this.getComponents().addFirst(this.getNoHandler());
        this.setCurrentProduct(new StringBuffer());
        this.putFront(TransparentHandler.IGNORE());
    }

    public StringBuffer getCurrentProduct() {
        logger.debug("getCurrentProduct() - start");
        return this.currentProduct;
    }

    public void setCurrentProduct(StringBuffer currentProduct) {
        logger.debug("setCurrentProduct(currentProduct=" + currentProduct + ") - start");
        this.currentProduct = currentProduct;
    }

    private void prepareNewPiece() {
        logger.debug("prepareNewPiece() - start");
        this.setCurrentProduct(new StringBuffer());
        try {
            while (!(this.getComponents().getFirst() instanceof TransparentHandler)) {
                this.removeFront();
            }
        }
        catch (PipelineException e) {
            logger.error("prepareNewPiece()", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void thePieceIsDone() {
        logger.debug("thePieceIsDone() - start");
        this.getProducts().add(this.getCurrentProduct().toString());
        this.prepareNewPiece();
    }

    public List getProducts() {
        logger.debug("getProducts() - start");
        return this.products;
    }

    protected void setProducts(List products) {
        logger.debug("setProducts(products=" + products + ") - start");
        this.products = products;
    }

    private LinkedList getComponents() {
        logger.debug("getComponents() - start");
        return this.components;
    }

    private void setComponents(LinkedList components) {
        logger.debug("setComponents(components=" + components + ") - start");
        this.components = components;
    }

    public void putFront(PipelineComponent component) {
        logger.debug("putFront(component=" + component + ") - start");
        component.setSuccessor((PipelineComponent)this.getComponents().getFirst());
        component.setPipeline(this);
        this.getComponents().addFirst(component);
    }

    public PipelineComponent removeFront() throws PipelineException {
        logger.debug("removeFront() - start");
        PipelineComponent first = (PipelineComponent)this.getComponents().getFirst();
        this.remove(first);
        return first;
    }

    public void remove(PipelineComponent component) throws PipelineException {
        logger.debug("remove(component=" + component + ") - start");
        if (component == this.getNoHandler()) {
            throw new PipelineException("Cannot remove the last handler");
        }
        if (!this.getComponents().remove(component)) {
            throw new PipelineException("Cannot remove a non existent component from a pipeline");
        }
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        logger.debug("canHandle(c=" + c + ") - start");
        return true;
    }

    public void handle(char c) throws IllegalInputCharacterException, PipelineException {
        logger.debug("handle(c=" + c + ") - start");
        ((Handler)this.getComponents().getFirst()).handle(c);
    }

    public boolean allowForNoMoreInput() {
        logger.debug("allowForNoMoreInput() - start");
        throw new IllegalStateException("you cannot call Pipeline.allowForNoMoreInput");
    }

    private PipelineComponent getNoHandler() {
        logger.debug("getNoHandler() - start");
        return this.noHandler;
    }

    private void setNoHandler(PipelineComponent noHandler) {
        logger.debug("setNoHandler(noHandler=" + noHandler + ") - start");
        this.noHandler = noHandler;
    }

    public void resetProducts() {
        logger.debug("resetProducts() - start");
        this.setProducts(new ArrayList());
    }

    public void noMoreInput() {
        logger.debug("noMoreInput() - start");
        ((Handler)this.getComponents().getFirst()).noMoreInput();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

