/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.Arrays;
import java.util.Comparator;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedTable
extends AbstractTable {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$SortedTable == null ? (class$org$dbunit$dataset$SortedTable = SortedTable.class$("org.dbunit.dataset.SortedTable")) : class$org$dbunit$dataset$SortedTable));
    private final ITable _table;
    private final Column[] _columns;
    private Integer[] _indexes;
    static /* synthetic */ Class class$org$dbunit$dataset$SortedTable;
    static /* synthetic */ Class class$org$dbunit$dataset$SortedTable$RowComparator;

    public SortedTable(ITable table, Column[] columns) {
        this._table = table;
        this._columns = columns;
    }

    public SortedTable(ITable table, String[] columnNames) throws DataSetException {
        this._table = table;
        this._columns = new Column[columnNames.length];
        Column[] columns = table.getTableMetaData().getColumns();
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            this._columns[i] = DataSetUtils.getColumn(columnName, columns);
        }
    }

    public SortedTable(ITable table, ITableMetaData metaData) throws DataSetException {
        this(table, metaData.getColumns());
    }

    public SortedTable(ITable table) throws DataSetException {
        this(table, table.getTableMetaData());
    }

    private int getOriginalRowIndex(int row) throws DataSetException {
        logger.debug("getOriginalRowIndex(row=" + row + ") - start");
        if (this._indexes == null) {
            Integer[] indexes = new Integer[this.getRowCount()];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = new Integer(i);
            }
            try {
                Arrays.sort(indexes, new RowComparator());
            }
            catch (DatabaseUnitRuntimeException e) {
                logger.error("getOriginalRowIndex()", (Throwable)e);
                throw (DataSetException)e.getException();
            }
            this._indexes = indexes;
        }
        return this._indexes[row];
    }

    public ITableMetaData getTableMetaData() {
        logger.debug("getTableMetaData() - start");
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        logger.debug("getRowCount() - start");
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        logger.debug("getValue(row=" + row + ", column=" + column + ") - start");
        this.assertValidRowIndex(row);
        return this._table.getValue(this.getOriginalRowIndex(row), column);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RowComparator
    implements Comparator {
        private final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$SortedTable$RowComparator == null ? (class$org$dbunit$dataset$SortedTable$RowComparator = SortedTable.class$("org.dbunit.dataset.SortedTable$RowComparator")) : class$org$dbunit$dataset$SortedTable$RowComparator));

        private RowComparator() {
        }

        public int compare(Object o1, Object o2) {
            this.logger.debug("compare(o1=" + o1 + ", o2=" + o2 + ") - start");
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            try {
                for (int i = 0; i < SortedTable.this._columns.length; ++i) {
                    String stringValue2;
                    String columnName = SortedTable.this._columns[i].getColumnName();
                    Object value1 = SortedTable.this._table.getValue(i1, columnName);
                    Object value2 = SortedTable.this._table.getValue(i2, columnName);
                    if (value1 == null && value2 == null) continue;
                    if (value1 == null && value2 != null) {
                        return -1;
                    }
                    if (value1 != null && value2 == null) {
                        return 1;
                    }
                    String stringValue1 = DataType.asString(value1);
                    int result = stringValue1.compareTo(stringValue2 = DataType.asString(value2));
                    if (result == 0) continue;
                    return result;
                }
            }
            catch (DataSetException e) {
                this.logger.error("compare()", (Throwable)e);
                throw new DatabaseUnitRuntimeException(e);
            }
            return 0;
        }
    }
}

