/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTable
extends AbstractTable {
    private static final Logger logger = LoggerFactory.getLogger((Class)(class$org$dbunit$dataset$DefaultTable == null ? (class$org$dbunit$dataset$DefaultTable = DefaultTable.class$("org.dbunit.dataset.DefaultTable")) : class$org$dbunit$dataset$DefaultTable));
    private final ITableMetaData _metaData;
    private final List _rowList;
    static /* synthetic */ Class class$org$dbunit$dataset$DefaultTable;

    public DefaultTable(ITableMetaData metaData, List list) {
        this._metaData = metaData;
        this._rowList = list;
    }

    public DefaultTable(String tableName) {
        this._metaData = new DefaultTableMetaData(tableName, new Column[0]);
        this._rowList = new ArrayList();
    }

    public DefaultTable(String tableName, Column[] columns, List list) {
        this._metaData = new DefaultTableMetaData(tableName, columns);
        this._rowList = list;
    }

    public DefaultTable(String tableName, Column[] columns) {
        this._metaData = new DefaultTableMetaData(tableName, columns);
        this._rowList = new ArrayList();
    }

    public DefaultTable(ITableMetaData metaData) {
        this._metaData = metaData;
        this._rowList = new ArrayList();
    }

    public void addRow() throws DataSetException {
        logger.debug("addRow() - start");
        int columnCount = this._metaData.getColumns().length;
        this._rowList.add(new Object[columnCount]);
    }

    public void addRow(Object[] values) throws DataSetException {
        logger.debug("addRow(values=" + values + ") - start");
        this._rowList.add(values);
    }

    public void addTableRows(ITable table) throws DataSetException {
        logger.debug("addTableRows(table=" + table + ") - start");
        try {
            Column[] columns = this._metaData.getColumns();
            if (columns.length > 0) {
                int i = 0;
                while (true) {
                    Object[] rowValues = new Object[columns.length];
                    for (int j = 0; j < columns.length; ++j) {
                        Column column = columns[j];
                        rowValues[j] = table.getValue(i, column.getColumnName());
                    }
                    this._rowList.add(rowValues);
                    ++i;
                }
            }
        }
        catch (RowOutOfBoundsException e) {
            logger.error("addTableRows()", (Throwable)e);
        }
    }

    public Object setValue(int row, String column, Object value) throws RowOutOfBoundsException, NoSuchColumnException, DataSetException {
        logger.debug("setValue(row=" + row + ", column=" + column + ", value=" + value + ") - start");
        this.assertValidRowIndex(row);
        Object[] rowValues = (Object[])this._rowList.get(row);
        int columnIndex = this.getColumnIndex(column);
        Object oldValue = rowValues[columnIndex];
        rowValues[columnIndex] = value;
        return oldValue;
    }

    public ITableMetaData getTableMetaData() {
        logger.debug("getTableMetaData() - start");
        return this._metaData;
    }

    public int getRowCount() {
        logger.debug("getRowCount() - start");
        return this._rowList.size();
    }

    public Object getValue(int row, String column) throws DataSetException {
        logger.debug("getValue(row=" + row + ", column=" + column + ") - start");
        this.assertValidRowIndex(row);
        Object[] rowValues = (Object[])this._rowList.get(row);
        return rowValues[this.getColumnIndex(column)];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

